/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.model;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public class PromptTemplate {
    private final String name;
    private final String content;
    private final String flavorName;
    private final String projectVersionId;
    private final String promptTemplateId;
    private final String promptTemplateVersionId;
    private final Map<String, Object> llmParameters;

    public PromptTemplate(String name, String content, String flavorName, String projectVersionId, String promptTemplateId, String promptTemplateVersionId, Map<String, Object> llmParameters) {
        this.name = name;
        this.content = content;
        this.flavorName = flavorName;
        this.projectVersionId = projectVersionId;
        this.promptTemplateId = promptTemplateId;
        this.promptTemplateVersionId = promptTemplateVersionId;
        this.llmParameters = llmParameters != null ? llmParameters : Collections.emptyMap();
    }

    public String getName() {
        return this.name;
    }

    public String getContent() {
        return this.content;
    }

    public String getFlavorName() {
        return this.flavorName;
    }

    public String getProjectVersionId() {
        return this.projectVersionId;
    }

    public String getPromptTemplateId() {
        return this.promptTemplateId;
    }

    public String getPromptTemplateVersionId() {
        return this.promptTemplateVersionId;
    }

    public Map<String, Object> getLLMParameters() {
        return this.llmParameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PromptTemplate template = (PromptTemplate)o;
        return Objects.equals(this.name, template.name) && Objects.equals(this.content, template.content) && Objects.equals(this.flavorName, template.flavorName) && Objects.equals(this.promptTemplateId, template.promptTemplateId) && Objects.equals(this.promptTemplateVersionId, template.promptTemplateVersionId) && Objects.equals(this.llmParameters, template.llmParameters);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.content, this.flavorName, this.promptTemplateId, this.promptTemplateVersionId, this.llmParameters);
    }

    public String toString() {
        return "PromptTemplate{name='" + this.name + "', content='" + this.content + "', flavorName='" + this.flavorName + "', projectVersionId='" + this.projectVersionId + "', promptTemplateId='" + this.promptTemplateId + "', promptTemplateVersionId='" + this.promptTemplateVersionId + "', llmParameters=" + this.llmParameters + "}";
    }
}

