/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.internal;

import ai.freeplay.client.exceptions.FreeplayClientException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.mustachejava.Code;
import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.ObjectHandler;
import com.github.mustachejava.reflect.ReflectionObjectHandler;
import com.github.mustachejava.util.Node;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class TemplateUtils {
    public static String format(String template, Map<String, Object> variables) {
        Mustache mustache;
        TemplateUtils.validateVariables(variables);
        NoEscapeMustacheFactory mf = new NoEscapeMustacheFactory();
        mf.setObjectHandler((ObjectHandler)new JSONObjectSerializingObjectHandler());
        try {
            mustache = mf.compile(new StringReader(template), "<template-name>");
        }
        catch (Exception e) {
            throw new FreeplayClientException("Unable to format template.", e);
        }
        StringWriter writer = new StringWriter();
        mustache.execute((Writer)writer, variables);
        writer.flush();
        return writer.toString();
    }

    private static void validateVariables(Map<String, Object> variables) {
        for (Map.Entry<String, Object> entry : variables.entrySet()) {
            TemplateUtils.validateValue(entry.getValue());
        }
    }

    private static void validateVariables(Collection<?> variables) {
        for (Object variable : variables) {
            TemplateUtils.validateValue(variable);
        }
    }

    private static void validateValue(Object variable) {
        if (TemplateUtils.isSimpleType(variable)) {
            return;
        }
        if (variable instanceof Collection) {
            TemplateUtils.validateVariables((Collection)variable);
        } else if (variable instanceof Map) {
            TemplateUtils.validateVariables((Map)variable);
        } else {
            throw new FreeplayClientException(String.format("Unsupported type provided as input variable: %s", variable.getClass().getName()));
        }
    }

    private static boolean isSimpleType(Object value) {
        return value instanceof String || value instanceof Number || value instanceof Boolean;
    }

    public static class NoOpMustache
    implements Mustache {
        public void append(String text) {
        }

        public Object clone() {
            return new NoOpMustache();
        }

        public Writer execute(Writer writer, List<Object> scopes) {
            return writer;
        }

        public Code[] getCodes() {
            return new Code[0];
        }

        public void identity(Writer writer) {
        }

        public void init() {
        }

        public Object clone(Set<Code> seen) {
            return new NoOpMustache();
        }

        public String getName() {
            return null;
        }

        public Node invert(Node node, String text, AtomicInteger position) {
            return node;
        }

        public void setCodes(Code[] codes) {
        }

        public Writer run(Writer writer, List<Object> scopes) {
            return writer;
        }

        public Node invert(String text) {
            return null;
        }
    }

    private static class NoEscapeMustacheFactory
    extends DefaultMustacheFactory {
        private NoEscapeMustacheFactory() {
        }

        public void encode(String value, Writer writer) {
            try {
                writer.write(value);
            }
            catch (IOException e) {
                throw new FreeplayClientException("Error formatting template.", e);
            }
        }

        public Mustache compilePartial(String s) {
            return new NoOpMustache();
        }
    }

    private static class JSONObjectSerializingObjectHandler
    extends ReflectionObjectHandler {
        ObjectMapper objectMapper = new ObjectMapper();

        private JSONObjectSerializingObjectHandler() {
        }

        public String stringify(Object object) {
            if (object == null) {
                return "";
            }
            if (object instanceof Number || object instanceof Boolean || object instanceof Character || object instanceof CharSequence) {
                return object.toString();
            }
            try {
                return this.objectMapper.writeValueAsString(object);
            }
            catch (JsonProcessingException e) {
                throw new FreeplayClientException("Error formatting template.", e);
            }
        }
    }
}

