/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.thin;

import ai.freeplay.client.exceptions.FreeplayConfigurationException;
import ai.freeplay.client.internal.JSONUtil;
import ai.freeplay.client.thin.LLMAdapters;
import ai.freeplay.client.thin.TemplateResolver;
import ai.freeplay.client.thin.internal.v2dto.TemplateDTO;
import ai.freeplay.client.thin.internal.v2dto.TemplatesDTO;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FilesystemTemplateResolver
implements TemplateResolver {
    private final Path promptsDirectory;

    public FilesystemTemplateResolver(Path rootDirectory) {
        if (!Files.isDirectory(rootDirectory, new LinkOption[0])) {
            throw new FreeplayConfigurationException(String.format("Path for templates is not a directory. [%s]%n", rootDirectory.toAbsolutePath()));
        }
        this.promptsDirectory = rootDirectory.resolve("freeplay/prompts");
        if (!Files.isDirectory(this.promptsDirectory, new LinkOption[0])) {
            throw new FreeplayConfigurationException(String.format("Path for templates does not appear to be a Freeplay prompts directory. [%s]%n", rootDirectory.toAbsolutePath()));
        }
    }

    @Override
    public CompletableFuture<TemplatesDTO> getPrompts(String projectId, String environment) {
        Path environmentDir = this.getEnvironmentDir(projectId, environment);
        List<TemplateDTO> templateList = Arrays.stream(Objects.requireNonNull(environmentDir.toFile().listFiles((dir, name) -> name.endsWith(".json")))).map(file -> this.toTemplate((File)file, projectId)).collect(Collectors.toList());
        return CompletableFuture.completedFuture(new TemplatesDTO(templateList));
    }

    @Override
    public CompletableFuture<TemplateDTO> getPrompt(String projectId, String templateName, String environment) {
        Path environmentDir = this.getEnvironmentDir(projectId, environment);
        Path templateFile = environmentDir.resolve(templateName + ".json");
        if (!Files.exists(templateFile, new LinkOption[0])) {
            throw new FreeplayConfigurationException(String.format("Could not find template %s for project %s and environment %s.%n", templateName, projectId, environment));
        }
        return CompletableFuture.completedFuture(this.toTemplate(templateFile.toFile(), projectId));
    }

    @Override
    public CompletableFuture<TemplateDTO> getPromptByVersionId(String projectId, String templateId, String templateVersionId) {
        try {
            List<Path> promptFilePaths = this.getAllPromptFilePaths(projectId);
            for (Path templateFile : promptFilePaths) {
                TemplateDTO templatePrompt = this.toTemplate(templateFile.toFile(), projectId);
                if (!templatePrompt.getPromptTemplateVersionId().equals(templateVersionId)) continue;
                return CompletableFuture.completedFuture(templatePrompt);
            }
            throw new FreeplayConfigurationException(String.format("Could not find template version id %s for project %s in local filesystem", templateVersionId, projectId));
        }
        catch (IOException e) {
            System.err.println("Failed to retrieve prompt file paths: " + e.getMessage());
            throw new RuntimeException("Error accessing prompt files", e);
        }
    }

    private Path getEnvironmentDir(String projectId, String environment) {
        Path environmentDir = this.promptsDirectory.resolve(projectId + "/" + environment);
        if (!Files.exists(environmentDir, new LinkOption[0])) {
            throw new FreeplayConfigurationException(String.format("Could not find directory for project %s and environment %s.%n", projectId, environment));
        }
        return environmentDir;
    }

    private List<Path> getAllPromptFilePaths(String projectId) throws IOException {
        Path projectDir = this.promptsDirectory.resolve(projectId);
        if (!Files.exists(projectDir, new LinkOption[0]) || !Files.isDirectory(projectDir, new LinkOption[0])) {
            throw new FreeplayConfigurationException(String.format("Could not find directory for project %s.%n", projectId));
        }
        try (Stream<Path> paths = Files.walk(projectDir, new FileVisitOption[0]);){
            List<Path> list = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".json")).collect(Collectors.toList());
            return list;
        }
    }

    private TemplateDTO toTemplate(File templateFile, String projectId) {
        File promptAbsoluteFile = templateFile.getAbsoluteFile();
        try {
            JsonNode templateNode = JSONUtil.parseDOM(Files.readString(promptAbsoluteFile.toPath()));
            if (FilesystemTemplateResolver.isFormat(templateNode, 2) | FilesystemTemplateResolver.isFormat(templateNode, 3)) {
                return new TemplateDTO(templateNode.get("prompt_template_id").textValue(), templateNode.get("prompt_template_version_id").textValue(), templateNode.get("prompt_template_name").textValue(), this.getV2Content(templateNode.get("content")), new TemplateDTO.Metadata(templateNode.path("metadata").path("provider").textValue(), templateNode.path("metadata").path("model").textValue(), templateNode.path("metadata").path("flavor").textValue(), JSONUtil.nodeToMap(templateNode.path("metadata").path("params")), JSONUtil.nodeToMap(templateNode.path("metadata").path("provider_info"))), templateNode.get("format_version").asInt(), projectId);
            }
            String flavorName = templateNode.path("metadata").path("flavor_name").textValue();
            if (flavorName == null) {
                throw new FreeplayConfigurationException(String.format("Flavor for prompt %s must be configured in the Freeplay UI. Unable to fulfill request.", templateNode.get("name").textValue()));
            }
            LLMAdapters.LLMAdapter<?> llmAdapter = LLMAdapters.adapterForFlavor(flavorName);
            String model = templateNode.path("metadata").path("params").path("model").textValue();
            if (model == null) {
                throw new FreeplayConfigurationException(String.format("Model for prompt %s must be configured in the Freeplay UI. Unable to fulfill request.", templateNode.get("name").textValue()));
            }
            Map<String, Object> params = JSONUtil.nodeToMap(templateNode.path("metadata").path("params"));
            params.remove("model");
            return new TemplateDTO(templateNode.get("prompt_template_id").textValue(), templateNode.get("prompt_template_version_id").textValue(), templateNode.get("name").textValue(), this.getV2Content(JSONUtil.parseDOM(templateNode.get("content").asText())), new TemplateDTO.Metadata(llmAdapter.getProvider(), model, flavorName, params, Collections.emptyMap()), 0, projectId);
        }
        catch (IOException e) {
            throw new FreeplayConfigurationException("Unable to read prompt template. ", e);
        }
    }

    private List<TemplateDTO.Message> getV2Content(JsonNode content) {
        ArrayList<TemplateDTO.Message> messages = new ArrayList<TemplateDTO.Message>(content.size());
        content.forEach(messageNode -> {
            if (messageNode.path("kind").isMissingNode()) {
                messages.add(new TemplateDTO.Message(this.translateRole(messageNode.get("role").textValue()), messageNode.get("content").textValue()));
            } else {
                messages.add(new TemplateDTO.Message(null, null, messageNode.path("kind").textValue()));
            }
        });
        return messages;
    }

    private String translateRole(String role) {
        switch (role) {
            case "Human": {
                return "user";
            }
            case "Assistant": {
                return "assistant";
            }
        }
        return role;
    }

    private static boolean isFormat(JsonNode templateNode, int version) {
        JsonNode formatVersionRaw = templateNode.path("format_version");
        if (formatVersionRaw.canConvertToInt()) {
            return formatVersionRaw.asInt() == version;
        }
        return false;
    }
}

