/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.thin.internal.dto;

import ai.freeplay.client.thin.resources.prompts.ChatMessage;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class RecordDTO {
    private List<ChatMessage> messages;
    private Map<String, Object> inputs;
    private SessionInfoDTO sessionInfo;
    private PromptInfoDTO promptInfo;
    private CallInfoDTO callInfo;
    private ResponseInfoDTO responseInfo;
    private TestRunInfoDTO testRunInfo;
    private Map<String, Object> evalResults;
    private TraceInfoDTO traceInfo;
    private List<Map<String, Object>> toolSchema;
    private UUID completionId;

    public RecordDTO() {
    }

    public RecordDTO(List<ChatMessage> messages, Map<String, Object> inputs, SessionInfoDTO sessionInfo, PromptInfoDTO promptInfo, CallInfoDTO callInfo, ResponseInfoDTO responseInfo, TestRunInfoDTO testRunInfo, Map<String, Object> evalResults, TraceInfoDTO traceInfo, List<Map<String, Object>> toolSchema, UUID completionId) {
        this.messages = messages;
        this.inputs = inputs;
        this.sessionInfo = sessionInfo;
        this.promptInfo = promptInfo;
        this.callInfo = callInfo;
        this.responseInfo = responseInfo;
        this.testRunInfo = testRunInfo;
        this.evalResults = evalResults;
        this.traceInfo = traceInfo;
        this.toolSchema = toolSchema;
        this.completionId = completionId;
    }

    public List<ChatMessage> getMessages() {
        return this.messages;
    }

    public Map<String, Object> getInputs() {
        return this.inputs;
    }

    public SessionInfoDTO getSessionInfo() {
        return this.sessionInfo;
    }

    public PromptInfoDTO getPromptInfo() {
        return this.promptInfo;
    }

    public CallInfoDTO getCallInfo() {
        return this.callInfo;
    }

    public ResponseInfoDTO getResponseInfo() {
        return this.responseInfo;
    }

    public TestRunInfoDTO getTestRunInfo() {
        return this.testRunInfo;
    }

    public TraceInfoDTO getTraceInfo() {
        return this.traceInfo;
    }

    public List<Map<String, Object>> getToolSchema() {
        return this.toolSchema;
    }

    public String toString() {
        return "RecordDTO{messages=" + this.messages + ", inputs=" + this.inputs + ", sessionInfo=" + this.sessionInfo + ", promptInfo=" + this.promptInfo + ", callInfo=" + this.callInfo + ", responseInfo=" + this.responseInfo + ", testRunInfo=" + this.testRunInfo + ", evalResults=" + this.evalResults + ", toolSchema=" + this.toolSchema + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecordDTO recordDTO = (RecordDTO)o;
        return Objects.equals(this.messages, recordDTO.messages) && Objects.equals(this.inputs, recordDTO.inputs) && Objects.equals(this.sessionInfo, recordDTO.sessionInfo) && Objects.equals(this.promptInfo, recordDTO.promptInfo) && Objects.equals(this.callInfo, recordDTO.callInfo) && Objects.equals(this.responseInfo, recordDTO.responseInfo) && Objects.equals(this.testRunInfo, recordDTO.testRunInfo) && Objects.equals(this.evalResults, recordDTO.evalResults) && Objects.equals(this.toolSchema, recordDTO.toolSchema);
    }

    public int hashCode() {
        return Objects.hash(this.messages, this.inputs, this.sessionInfo, this.promptInfo, this.callInfo, this.responseInfo, this.testRunInfo, this.evalResults, this.toolSchema);
    }

    public Map<String, Object> getEvalResults() {
        return this.evalResults;
    }

    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class TraceInfoDTO {
        private UUID traceId;

        public TraceInfoDTO() {
        }

        public TraceInfoDTO(UUID traceId) {
            this.traceId = traceId;
        }

        public UUID getTraceId() {
            return this.traceId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TraceInfoDTO that = (TraceInfoDTO)o;
            return Objects.equals(this.traceId, that.traceId);
        }

        public int hashCode() {
            return Objects.hash(this.traceId);
        }

        public String toString() {
            return "TraceInfoDTO{traceId='" + this.traceId + "'}";
        }
    }

    public static class OpenAIFunctionCallDTO {
        private String name;
        private String arguments;

        public OpenAIFunctionCallDTO() {
        }

        public OpenAIFunctionCallDTO(String name, String arguments) {
            this.name = name;
            this.arguments = arguments;
        }

        public String getName() {
            return this.name;
        }

        public String getArguments() {
            return this.arguments;
        }

        public Map<String, String> asMap() {
            return Map.of("name", this.name, "arguments", this.arguments);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OpenAIFunctionCallDTO that = (OpenAIFunctionCallDTO)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.arguments, that.arguments);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.arguments);
        }

        public String toString() {
            return "OpenAIFunctionCallDTO{name='" + this.name + "', arguments='" + this.arguments + "'}";
        }
    }

    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class TestRunInfoDTO {
        private String testRunId;
        private String testCaseId;

        public TestRunInfoDTO() {
        }

        public TestRunInfoDTO(String testRunId, String testCaseId) {
            this.testRunId = testRunId;
            this.testCaseId = testCaseId;
        }

        public String getTestRunId() {
            return this.testRunId;
        }

        public String getTestCaseId() {
            return this.testCaseId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestRunInfoDTO that = (TestRunInfoDTO)o;
            return Objects.equals(this.testRunId, that.testRunId) && Objects.equals(this.testCaseId, that.testCaseId);
        }

        public int hashCode() {
            return Objects.hash(this.testRunId, this.testCaseId);
        }

        public String toString() {
            return "TestRunInfoDTO{testRunId='" + this.testRunId + "', testCaseId='" + this.testCaseId + "'}";
        }
    }

    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class ResponseInfoDTO {
        private boolean isComplete;
        private OpenAIFunctionCallDTO functionCall;
        private int promptTokens;
        private int responseTokens;

        public ResponseInfoDTO() {
        }

        public ResponseInfoDTO(boolean isComplete) {
            this.isComplete = isComplete;
        }

        public ResponseInfoDTO(boolean isComplete, OpenAIFunctionCallDTO functionCall, int promptTokens, int responseTokens) {
            this.isComplete = isComplete;
            this.functionCall = functionCall;
            this.promptTokens = promptTokens;
            this.responseTokens = responseTokens;
        }

        public ResponseInfoDTO functionCall(OpenAIFunctionCallDTO functionCall) {
            this.functionCall = functionCall;
            return this;
        }

        public ResponseInfoDTO promptTokens(int promptTokens) {
            this.promptTokens = promptTokens;
            return this;
        }

        public ResponseInfoDTO responseTokens(int responseTokens) {
            this.responseTokens = responseTokens;
            return this;
        }

        public boolean getIsComplete() {
            return this.isComplete;
        }

        public OpenAIFunctionCallDTO getFunctionCall() {
            return this.functionCall;
        }

        public int getPromptTokens() {
            return this.promptTokens;
        }

        public int getResponseTokens() {
            return this.responseTokens;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResponseInfoDTO that = (ResponseInfoDTO)o;
            return Objects.equals(this.isComplete, that.isComplete) && Objects.equals(this.functionCall, that.functionCall) && Objects.equals(this.promptTokens, that.promptTokens) && Objects.equals(this.responseTokens, that.responseTokens);
        }

        public int hashCode() {
            return Objects.hash(this.isComplete, this.functionCall, this.promptTokens, this.responseTokens);
        }

        public String toString() {
            return "ResponseInfoDTO{isComplete='" + this.isComplete + "', functionCall='" + this.functionCall + "', promptTokens='" + this.promptTokens + "', responseTokens='" + this.responseTokens + "'}";
        }
    }

    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class CallInfoDTO {
        private String provider;
        private String model;
        private double startTime;
        private double endTime;
        private Map<String, Object> modelParameters;
        private Map<String, Object> providerInfo;

        public CallInfoDTO() {
        }

        public CallInfoDTO(String provider, String model, double startTime, double endTime, Map<String, Object> modelParameters) {
            this.provider = provider;
            this.model = model;
            this.startTime = startTime;
            this.endTime = endTime;
            this.modelParameters = modelParameters;
        }

        public CallInfoDTO providerInfo(Map<String, Object> providerInfo) {
            this.providerInfo = providerInfo;
            return this;
        }

        public String getProvider() {
            return this.provider;
        }

        public String getModel() {
            return this.model;
        }

        public double getStartTime() {
            return this.startTime;
        }

        public double getEndTime() {
            return this.endTime;
        }

        public Map<String, Object> getModelParameters() {
            return this.modelParameters;
        }

        public Map<String, Object> getProviderInfo() {
            return this.providerInfo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CallInfoDTO that = (CallInfoDTO)o;
            return Objects.equals(this.provider, that.provider) && Objects.equals(this.model, that.model) && Objects.equals(this.startTime, that.startTime) && Objects.equals(this.endTime, that.endTime) && Objects.equals(this.modelParameters, that.modelParameters) && Objects.equals(this.providerInfo, that.providerInfo);
        }

        public int hashCode() {
            return Objects.hash(this.provider, this.model, this.startTime, this.endTime, this.modelParameters, this.providerInfo);
        }

        public String toString() {
            return "CallInfoDTO{provider='" + this.provider + "', model='" + this.model + "', startTime='" + this.startTime + "', endTime='" + this.endTime + "', modelParameters=" + this.modelParameters + ", providerInfo=" + this.providerInfo + "}";
        }
    }

    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class PromptInfoDTO {
        private String promptTemplateId;
        private String promptTemplateVersionId;
        private String templateName;
        private String environment;
        private Map<String, Object> modelParameters;
        private Map<String, Object> providerInfo;
        private String provider;
        private String model;
        private String flavorName;
        private String projectId;

        public PromptInfoDTO() {
        }

        public PromptInfoDTO(String promptTemplateId, String promptTemplateVersionId, String templateName, String environment, Map<String, Object> modelParameters, Map<String, Object> providerInfo, String provider, String model, String flavorName, String projectId) {
            this.promptTemplateId = promptTemplateId;
            this.promptTemplateVersionId = promptTemplateVersionId;
            this.templateName = templateName;
            this.environment = environment;
            this.modelParameters = modelParameters;
            this.providerInfo = providerInfo;
            this.provider = provider;
            this.model = model;
            this.flavorName = flavorName;
            this.projectId = projectId;
        }

        public String getPromptTemplateId() {
            return this.promptTemplateId;
        }

        public String getPromptTemplateVersionId() {
            return this.promptTemplateVersionId;
        }

        public String getTemplateName() {
            return this.templateName;
        }

        public String getEnvironment() {
            return this.environment;
        }

        public Map<String, Object> getModelParameters() {
            return this.modelParameters;
        }

        public Map<String, Object> getProviderInfo() {
            return this.providerInfo;
        }

        public String getProvider() {
            return this.provider;
        }

        public String getModel() {
            return this.model;
        }

        public String getFlavorName() {
            return this.flavorName;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PromptInfoDTO that = (PromptInfoDTO)o;
            return Objects.equals(this.promptTemplateId, that.promptTemplateId) && Objects.equals(this.promptTemplateVersionId, that.promptTemplateVersionId) && Objects.equals(this.templateName, that.templateName) && Objects.equals(this.environment, that.environment) && Objects.equals(this.modelParameters, that.modelParameters) && Objects.equals(this.providerInfo, that.providerInfo) && Objects.equals(this.provider, that.provider) && Objects.equals(this.model, that.model) && Objects.equals(this.flavorName, that.flavorName);
        }

        public int hashCode() {
            return Objects.hash(this.promptTemplateId, this.promptTemplateVersionId, this.templateName, this.environment, this.modelParameters, this.providerInfo, this.provider, this.model, this.flavorName);
        }

        public String toString() {
            return "PromptInfo{promptTemplateId='" + this.promptTemplateId + "', promptTemplateVersionId='" + this.promptTemplateVersionId + "', templateName='" + this.templateName + "', environment='" + this.environment + "', modelParameters=" + this.modelParameters + ", providerInfo=" + this.providerInfo + ", provider='" + this.provider + "', model='" + this.model + "', flavorName='" + this.flavorName + "'}";
        }
    }

    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class SessionInfoDTO {
        private String sessionId;
        private Map<String, Object> customMetadata;

        public SessionInfoDTO() {
        }

        public SessionInfoDTO(String sessionId, Map<String, Object> customMetadata) {
            this.sessionId = sessionId;
            this.customMetadata = customMetadata;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public Map<String, Object> getCustomMetadata() {
            return this.customMetadata;
        }

        public String toString() {
            return "SessionInfoDTO{sessionId=" + this.sessionId + ", customMetadata=" + this.customMetadata + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SessionInfoDTO sessionInfoDTO = (SessionInfoDTO)o;
            return Objects.equals(this.sessionId, sessionInfoDTO.sessionId) && Objects.equals(this.customMetadata, sessionInfoDTO.customMetadata);
        }

        public int hashCode() {
            return Objects.hash(this.sessionId, this.customMetadata);
        }
    }
}

