/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.thin.resources.prompts;

import ai.freeplay.client.thin.LLMAdapters;
import ai.freeplay.client.thin.internal.ThinCallSupport;
import ai.freeplay.client.thin.internal.v2dto.TemplateDTO;
import ai.freeplay.client.thin.resources.prompts.ChatMessage;
import ai.freeplay.client.thin.resources.prompts.FormattedPrompt;
import ai.freeplay.client.thin.resources.prompts.PromptInfo;
import java.util.List;

public class BoundPrompt {
    private final PromptInfo promptInfo;
    private final List<ChatMessage> messages;
    private final List<TemplateDTO.ToolSchema> toolSchema;

    public BoundPrompt(PromptInfo promptInfo, List<ChatMessage> messages) {
        this(promptInfo, messages, null);
    }

    public BoundPrompt(PromptInfo promptInfo, List<ChatMessage> messages, List<TemplateDTO.ToolSchema> toolSchema) {
        this.promptInfo = promptInfo;
        this.messages = messages;
        this.toolSchema = toolSchema;
    }

    public PromptInfo getPromptInfo() {
        return this.promptInfo;
    }

    public List<ChatMessage> getMessages() {
        return this.messages;
    }

    public <ContentFormat> FormattedPrompt<ContentFormat> format() {
        return this.format(null);
    }

    public <ContentFormat> FormattedPrompt<ContentFormat> format(String flavorName) {
        String finalFlavor = ThinCallSupport.getActiveFlavorName(flavorName, this.promptInfo.getFlavorName());
        LLMAdapters.LLMAdapter<?> llmAdapter = LLMAdapters.adapterForFlavor(finalFlavor);
        Object llmSyntax = llmAdapter.toLLMSyntax(this.messages);
        if (this.toolSchema == null) {
            return new FormattedPrompt(this.getPromptInfo(), this.getMessages(), llmSyntax, null);
        }
        return new FormattedPrompt(this.getPromptInfo(), this.getMessages(), llmSyntax, llmAdapter.toToolSchemaFormat(this.toolSchema));
    }
}

