/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.thin.resources.prompts;

import ai.freeplay.client.thin.resources.prompts.ChatMessageDeserializer;
import ai.freeplay.client.thin.resources.prompts.ChatMessageSerializer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.List;
import java.util.Objects;

@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
@JsonSerialize(using=ChatMessageSerializer.class)
@JsonDeserialize(using=ChatMessageDeserializer.class)
public class ChatMessage {
    private String role;
    private String content;
    private List<Object> structuredContent;
    private Object completionMessage;

    public ChatMessage() {
    }

    public ChatMessage(String role, String content) {
        this.role = role;
        this.content = content;
    }

    public ChatMessage(String role, List<Object> structuredContent) {
        this.role = role;
        this.structuredContent = structuredContent;
    }

    public ChatMessage(Object completionMessage) {
        this.completionMessage = completionMessage;
    }

    public String getRole() {
        return this.role;
    }

    public String getContent() {
        if (this.isEmptyMessage()) {
            return null;
        }
        if (this.isCompletionMessage()) {
            throw new IllegalStateException("Message is not a string, use getCompletionMessage() instead");
        }
        if (this.isStructuredMessage()) {
            throw new IllegalStateException("Message is not a string, use getStructuredContent() instead");
        }
        return this.content;
    }

    public List<Object> getStructuredContent() {
        if (this.isEmptyMessage()) {
            return null;
        }
        if (this.isStringMessage()) {
            throw new IllegalStateException("Message is not a list, use getContent() instead");
        }
        if (this.isCompletionMessage()) {
            throw new IllegalStateException("Message is not a list, use getCompletionMessage() instead");
        }
        return this.structuredContent;
    }

    public Object getCompletionMessage() {
        if (this.isEmptyMessage()) {
            return null;
        }
        if (this.isStringMessage()) {
            throw new IllegalStateException("Message is not a completion message, use getContent() instead");
        }
        if (this.isStructuredMessage()) {
            throw new IllegalStateException("Message is not a string, use getStructuredContent() instead");
        }
        return this.completionMessage;
    }

    @JsonIgnore
    public boolean isKind() {
        return false;
    }

    protected boolean isEmptyMessage() {
        return this.content == null && this.structuredContent == null && this.completionMessage == null;
    }

    protected boolean isStringMessage() {
        return this.content != null;
    }

    protected boolean isStructuredMessage() {
        return this.structuredContent != null;
    }

    protected boolean isCompletionMessage() {
        return this.completionMessage != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChatMessage that = (ChatMessage)o;
        return Objects.equals(this.role, that.role) && Objects.equals(this.content, that.content) && Objects.equals(this.structuredContent, that.structuredContent) && Objects.equals(this.completionMessage, that.completionMessage);
    }

    public int hashCode() {
        return Objects.hash(this.role, this.content, this.structuredContent, this.completionMessage);
    }

    public String toString() {
        return "ChatMessage{role='" + this.role + "', content='" + this.content + "', structuredContent='" + this.structuredContent + "', completionMessage='" + this.completionMessage + "'}";
    }
}

