/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.thin.resources.prompts;

import ai.freeplay.client.thin.resources.prompts.ChatMessage;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.ArrayList;

public class ChatMessageDeserializer
extends JsonDeserializer<ChatMessage> {
    public ChatMessage deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        String role = node.get("role").asText();
        JsonNode contentNode = node.get("content");
        if (contentNode.isNull()) {
            return new ChatMessage(role, (String)null);
        }
        if (contentNode.isArray()) {
            ArrayList<Object> structuredContent = new ArrayList<Object>();
            ArrayNode arrayNode = (ArrayNode)contentNode;
            for (JsonNode item : arrayNode) {
                structuredContent.add(p.getCodec().treeToValue((TreeNode)item, Object.class));
            }
            return new ChatMessage(role, structuredContent);
        }
        if (contentNode.isTextual()) {
            return new ChatMessage(role, contentNode.asText());
        }
        ArrayList<Object> structuredContent = new ArrayList<Object>();
        structuredContent.add(p.getCodec().treeToValue((TreeNode)contentNode, Object.class));
        return new ChatMessage(role, structuredContent);
    }
}

