/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.thin.resources.prompts;

import ai.freeplay.client.thin.resources.prompts.ChatMessage;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Map;

public class ChatMessageSerializer
extends JsonSerializer<ChatMessage> {
    public void serialize(ChatMessage message, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (message.isCompletionMessage()) {
            Object content = message.getCompletionMessage();
            if (content instanceof Map) {
                Map contentMap = (Map)content;
                gen.writeStartObject();
                for (Map.Entry entry : contentMap.entrySet()) {
                    gen.writeObjectField((String)entry.getKey(), entry.getValue());
                }
                gen.writeEndObject();
            } else {
                provider.defaultSerializeValue(content, gen);
            }
        } else {
            gen.writeStartObject();
            gen.writeStringField("role", message.getRole());
            if (message.isEmptyMessage() || message.isStringMessage()) {
                gen.writeStringField("content", message.getContent());
            } else {
                gen.writeObjectField("content", message.getStructuredContent());
            }
            gen.writeEndObject();
        }
    }
}

