/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.thin.resources.prompts;

import ai.freeplay.client.thin.resources.prompts.ChatMessage;
import ai.freeplay.client.thin.resources.prompts.PromptInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class FormattedPrompt<LLMContentFormat> {
    private final PromptInfo promptInfo;
    private final List<ChatMessage> boundMessages;
    private final LLMContentFormat formattedPrompt;
    private final List<Map<String, Object>> toolSchema;

    public FormattedPrompt(PromptInfo promptInfo, List<ChatMessage> messages, LLMContentFormat formattedPrompt) {
        this(promptInfo, messages, formattedPrompt, null);
    }

    public FormattedPrompt(PromptInfo promptInfo, List<ChatMessage> messages, LLMContentFormat formattedPrompt, List<Map<String, Object>> toolSchema) {
        this.promptInfo = promptInfo;
        this.boundMessages = messages;
        this.formattedPrompt = formattedPrompt;
        this.toolSchema = toolSchema;
    }

    public PromptInfo getPromptInfo() {
        return this.promptInfo;
    }

    public List<ChatMessage> getBoundMessages() {
        return this.boundMessages;
    }

    public LLMContentFormat getFormattedPrompt() {
        return this.formattedPrompt;
    }

    public Optional<String> getSystemContent() {
        try {
            return this.boundMessages.stream().filter(msg -> msg.getRole().equals("system")).findFirst().map(ChatMessage::getContent);
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException("System message must be a string");
        }
    }

    public List<Map<String, Object>> getToolSchema() {
        return this.toolSchema;
    }

    public List<ChatMessage> allMessages(ChatMessage message) {
        ArrayList<ChatMessage> newList = new ArrayList<ChatMessage>(this.boundMessages);
        newList.add(message);
        return newList;
    }

    public List<ChatMessage> allMessages(Object completionMessage) {
        ArrayList<ChatMessage> newList = new ArrayList<ChatMessage>(this.boundMessages);
        newList.add(new ChatMessage(completionMessage));
        return newList;
    }
}

