/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.thin.resources.recordings;

import ai.freeplay.client.thin.resources.recordings.OpenAIFunctionCall;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import java.util.Map;

@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class ResponseInfo {
    private final boolean isComplete;
    private OpenAIFunctionCall functionCall;
    private int promptTokens;
    private int responseTokens;

    public ResponseInfo(boolean isComplete) {
        this.isComplete = isComplete;
    }

    public ResponseInfo(boolean isComplete, OpenAIFunctionCall functionCall, int promptTokens, int responseTokens) {
        this.isComplete = isComplete;
        this.functionCall = functionCall;
        this.promptTokens = promptTokens;
        this.responseTokens = responseTokens;
    }

    public ResponseInfo functionCall(OpenAIFunctionCall functionCall) {
        this.functionCall = functionCall;
        return this;
    }

    public ResponseInfo promptTokens(int promptTokens) {
        this.promptTokens = promptTokens;
        return this;
    }

    public ResponseInfo responseTokens(int responseTokens) {
        this.responseTokens = responseTokens;
        return this;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public OpenAIFunctionCall getFunctionCall() {
        return this.functionCall;
    }

    public Map<String, String> getFunctionCallMap() {
        if (this.functionCall == null) {
            return null;
        }
        return this.functionCall.asMap();
    }

    public int getPromptTokens() {
        return this.promptTokens;
    }

    public int getResponseTokens() {
        return this.responseTokens;
    }

    public String toString() {
        return "ResponseInfo{isComplete=" + this.isComplete + ", functionCall=" + this.functionCall + ", promptTokens=" + this.promptTokens + ", responseTokens=" + this.responseTokens + "}";
    }
}

