/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.internal;

import ai.freeplay.client.exceptions.FreeplayException;
import ai.freeplay.client.internal.JSONUtil;
import com.fasterxml.jackson.jr.ob.JSON;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Map;

public class Http {
    public static HttpResponse<String> postWithBearer(String url, String apiKey) throws FreeplayException {
        return Http.postJsonWithBearer(url, (String)null, apiKey, HttpResponse.BodyHandlers.ofString());
    }

    public static HttpResponse<String> postJsonWithBearer(String url, Map<String, Object> body, String apiKey) throws FreeplayException {
        String jsonString = JSONUtil.asString(body);
        return Http.postJsonWithBearer(url, jsonString, apiKey, HttpResponse.BodyHandlers.ofString());
    }

    public static <R> HttpResponse<R> postJsonWithBearer(String url, Map<String, Object> body, String apiKey, HttpResponse.BodyHandler<R> responseBodyHandler) throws FreeplayException {
        return Http.postJsonWithBearer(url, JSONUtil.asString(body), apiKey, responseBodyHandler);
    }

    public static <R> HttpResponse<R> postJsonWithBearer(String url, String body, String apiKey, HttpResponse.BodyHandler<R> responseBodyHandler) throws FreeplayException {
        HttpRequest.Builder request;
        HttpRequest.BodyPublisher bodyPublisher = body != null ? HttpRequest.BodyPublishers.ofString(body) : HttpRequest.BodyPublishers.noBody();
        try {
            request = HttpRequest.newBuilder(new URI(url)).header("Content-Type", "application/json").POST(bodyPublisher);
        }
        catch (URISyntaxException e) {
            throw new FreeplayException("Error in URL during POST request. ", e);
        }
        if (apiKey != null) {
            request.header("Authorization", String.format("Bearer %s", apiKey));
        }
        try {
            return HttpClient.newHttpClient().send(request.build(), responseBodyHandler);
        }
        catch (Exception e) {
            throw new FreeplayException("Error sending POST request.", e);
        }
    }

    public static HttpResponse<String> get(String url, String apiKey) throws FreeplayException {
        HttpRequest.Builder request;
        try {
            request = HttpRequest.newBuilder(new URI(url));
        }
        catch (URISyntaxException e) {
            throw new FreeplayException("Error in URL during GET request. ", e);
        }
        if (apiKey != null) {
            request.header("Authorization", String.format("Bearer %s", apiKey));
        }
        try {
            return HttpClient.newHttpClient().send(request.build(), HttpResponse.BodyHandlers.ofString());
        }
        catch (Exception e) {
            throw new FreeplayException("Error sending GET request.", e);
        }
    }

    public static Map<String, Object> parseBody(HttpResponse<String> response) throws FreeplayException {
        try {
            return JSON.std.mapFrom((Object)response.body());
        }
        catch (IOException e) {
            throw new FreeplayException("Unable to parse JSON.", e);
        }
    }

    public static void throwIfError(HttpResponse<String> response, int expectedStatus) throws FreeplayException {
        if (response.statusCode() != expectedStatus) {
            Map<String, Object> bodyMap = Http.parseBody(response);
            Object message = bodyMap.get("message");
            if (message != null) {
                throw new FreeplayException(String.format("Error making call [%s]: %s", response.statusCode(), message));
            }
            throw new FreeplayException(String.format("Error making call [%s]", response.statusCode()));
        }
    }
}

