/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.model;

import ai.freeplay.client.exceptions.FreeplayException;
import ai.freeplay.client.flavor.ChatFlavor;
import ai.freeplay.client.flavor.Flavor;
import ai.freeplay.client.internal.CallSupport;
import ai.freeplay.client.model.ChatCompletionResponse;
import ai.freeplay.client.model.CompletionResponse;
import ai.freeplay.client.model.PromptTemplate;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public class CompletionSession {
    private final CallSupport callSupport;
    private final String sessionId;
    private final Collection<PromptTemplate> promptTemplates;
    private final String tag;
    private final String testRunId;

    public CompletionSession(CallSupport callSupport, String sessionId, Collection<PromptTemplate> prompts, String environment) {
        this(callSupport, sessionId, prompts, environment, null);
    }

    public CompletionSession(CallSupport callSupport, String sessionId, Collection<PromptTemplate> prompts, String environment, String testRunId) {
        this.callSupport = callSupport;
        this.sessionId = sessionId;
        this.promptTemplates = prompts;
        this.tag = environment;
        this.testRunId = testRunId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public CompletionResponse getCompletion(String templateName, Map<String, Object> variables) {
        return this.getCompletion(templateName, variables, Collections.emptyMap(), null);
    }

    public CompletionResponse getCompletion(String templateName, Map<String, Object> variables, Map<String, Object> llmParameters) {
        return this.getCompletion(templateName, variables, llmParameters, null);
    }

    public <P, R> CompletionResponse getCompletion(String templateName, Map<String, Object> variables, Map<String, Object> llmParameters, Flavor<P, R> flavor) {
        return this.callSupport.prepareAndMakeCall(this.getSessionId(), this.promptTemplates, templateName, variables, llmParameters, this.tag, this.testRunId, flavor);
    }

    public <P, R> Stream<R> getCompletionStream(String templateName, Map<String, Object> variables, Map<String, Object> llmParameters, String testRunId, Flavor<P, R> flavor) {
        PromptTemplate template = this.callSupport.findPrompt(this.promptTemplates, templateName).orElseThrow(() -> new FreeplayException("Unable to find prompt template with name " + templateName + " in environment " + this.tag));
        return this.callSupport.makeCallStream(this.getSessionId(), template, variables, llmParameters, this.tag, testRunId, flavor);
    }

    public ChatCompletionResponse getChatCompletion(String templateName, Map<String, Object> variables) {
        return this.getChatCompletion(templateName, variables, Collections.emptyMap(), null, null);
    }

    public ChatCompletionResponse getChatCompletion(String templateName, Map<String, Object> variables, Map<String, Object> llmParameters) {
        return this.getChatCompletion(templateName, variables, llmParameters, null, null);
    }

    public <P, R> ChatCompletionResponse getChatCompletion(String templateName, Map<String, Object> variables, Map<String, Object> llmParameters, String testRunId, Flavor<P, R> flavor) {
        Optional<PromptTemplate> maybePrompt = this.callSupport.findPrompt(this.promptTemplates, templateName);
        return maybePrompt.map(prompt -> {
            ChatFlavor activeFlavor = this.callSupport.getActiveChatFlavor(flavor, (PromptTemplate)prompt);
            Collection formattedPrompt = (Collection)activeFlavor.formatPrompt(prompt.getContent(), variables);
            return this.callSupport.makeContinueChatCall(this.getSessionId(), (PromptTemplate)prompt, formattedPrompt, variables, llmParameters, this.tag, testRunId);
        }).orElseThrow(() -> new FreeplayException(String.format("Prompt template %s not found in environment %s.", templateName, this.tag)));
    }
}

