/*
 * Decompiled with CFR 0.152.
 */
package ai.freeplay.client.flavor;

import ai.freeplay.client.ProviderConfig;
import ai.freeplay.client.exceptions.FreeplayException;
import ai.freeplay.client.flavor.Flavor;
import ai.freeplay.client.internal.Http;
import ai.freeplay.client.internal.JSONUtil;
import ai.freeplay.client.internal.StringUtils;
import ai.freeplay.client.internal.TemplateUtils;
import ai.freeplay.client.model.CompletionResponse;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;

public class AnthropicFlavor
implements Flavor<String, CompletionResponse> {
    private static final String ANTHROPIC_COMPLETIONS_URL = "https://api.anthropic.com/v1/complete";
    private static final String ANTHROPIC_VERSION = "2023-06-01";

    @Override
    public String getFormatType() {
        return "anthropic_text";
    }

    @Override
    public String getProvider() {
        return "anthropic";
    }

    @Override
    public String formatPrompt(String template, Map<String, Object> variables) {
        return TemplateUtils.format(template, variables);
    }

    @Override
    public CompletionResponse callService(String formattedPrompt, ProviderConfig providerConfig, Map<String, Object> mergedLLMParameters) throws FreeplayException {
        HttpResponse<String> response;
        AnthropicFlavor.validateParameters(mergedLLMParameters);
        Map<String, Object> bodyMap = AnthropicFlavor.getRequestBody(formattedPrompt, mergedLLMParameters);
        try {
            response = Http.postJson(ANTHROPIC_COMPLETIONS_URL, bodyMap, "accept", "application/json", "anthropic-version", ANTHROPIC_VERSION, "x-api-key", providerConfig.getApiKey());
        }
        catch (Exception e) {
            throw new FreeplayException("Error calling Anthropic.", e);
        }
        Map<String, Object> responseBody = Http.parseBody(response);
        Http.throwIfError(response, 200);
        boolean isComplete = "stop_sequence".equals(responseBody.get("stop_reason"));
        return new CompletionResponse(String.valueOf(responseBody.get("completion")), isComplete, true);
    }

    @Override
    public Stream<CompletionResponse> callServiceStream(String formattedPrompt, ProviderConfig providerConfig, Map<String, Object> mergedLLMParameters) {
        HttpResponse<Stream<String>> response;
        AnthropicFlavor.validateParameters(mergedLLMParameters);
        Map<String, Object> bodyMap = AnthropicFlavor.getRequestBody(formattedPrompt, mergedLLMParameters);
        bodyMap.put("stream", true);
        try {
            response = Http.postJson(ANTHROPIC_COMPLETIONS_URL, bodyMap, HttpResponse.BodyHandlers.ofLines(), "accept", "application/json", "anthropic-version", ANTHROPIC_VERSION, "x-api-key", providerConfig.getApiKey());
        }
        catch (Exception e) {
            throw new FreeplayException("Error calling Anthropic.", e);
        }
        AtomicReference<StreamState> streamStateRef = new AtomicReference<StreamState>(new StreamState());
        return response.body().map(line -> this.handleLine((String)line, (StreamState)streamStateRef.get())).filter(Objects::nonNull);
    }

    @Override
    public String serializeForRecord(String formattedPrompt) {
        return formattedPrompt;
    }

    @Override
    public String getContentFromChunk(CompletionResponse chunk) {
        return chunk.getContent();
    }

    @Override
    public boolean isLastChunk(CompletionResponse chunk) {
        return chunk.isLast();
    }

    @Override
    public boolean isComplete(CompletionResponse chunk) {
        return chunk.isComplete();
    }

    private static Map<String, Object> getRequestBody(String formattedPrompt, Map<String, Object> llmParameters) {
        HashMap<String, Object> bodyMap = new HashMap<String, Object>(llmParameters);
        bodyMap.put("prompt", AnthropicFlavor.toAnthropicPrompt(formattedPrompt));
        return bodyMap;
    }

    private static String toAnthropicPrompt(String formattedPrompt) {
        return String.format("\n\nHuman: %s \n\nAssistant:", formattedPrompt);
    }

    private static void validateParameters(Map<String, Object> llmParameters) {
        if (!llmParameters.containsKey("model")) {
            throw new FreeplayException("The 'model' parameter is required when calling Anthropic.");
        }
        if (!llmParameters.containsKey("max_tokens_to_sample")) {
            throw new FreeplayException("The 'max_tokens_to_sample' parameter is required when calling Anthropic.");
        }
        if (llmParameters.containsKey("prompt")) {
            throw new FreeplayException("The 'prompt' parameter cannot be specified. It is populated automatically.");
        }
    }

    private CompletionResponse handleLine(String line, StreamState streamState) {
        String fieldValue;
        if (StringUtils.isBlank(line)) {
            return AnthropicFlavor.finishEvent(streamState);
        }
        String[] fields = line.split(":", 2);
        if (fields.length == 2) {
            String fieldName = fields[0].trim();
            fieldValue = fields[1].stripLeading();
            if ("data".equals(fieldName)) {
                if (StringUtils.isBlank(fieldValue.trim())) {
                    return null;
                }
                Map<String, Object> objectMap = JSONUtil.parseMap(fieldValue);
                streamState.appendData((String)objectMap.get("completion"));
                streamState.setStopReason((String)objectMap.get("stop_reason"));
                return null;
            }
            if (!"event".equals(fieldName)) {
                throw new FreeplayException("Got unknown field in the stream: '" + fieldName + "'");
            }
        } else {
            throw new FreeplayException("Got unknown line in the stream: '" + line + "'");
        }
        streamState.startEvent(fieldValue);
        return null;
    }

    private static CompletionResponse finishEvent(StreamState streamState) {
        if ("completion".equals(streamState.eventName)) {
            return streamState.closeCurrentEvent();
        }
        streamState.reset();
        return null;
    }

    private static class StreamState {
        private final Object lock = new Object();
        private String eventName;
        private StringBuilder data;
        private String stopReason;
        private boolean isComplete;

        private StreamState() {
            this.reset();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startEvent(String name) {
            Object object = this.lock;
            synchronized (object) {
                if (this.eventName != null) {
                    throw new FreeplayException(String.format("Attempting to start a new event (%s) when the previous has not been closed.%n", name));
                }
                this.eventName = name;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void appendData(String newData) {
            if (newData != null) {
                Object object = this.lock;
                synchronized (object) {
                    this.data.append(newData);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CompletionResponse closeCurrentEvent() {
            Object object = this.lock;
            synchronized (object) {
                boolean isLast = this.stopReason != null;
                CompletionResponse response = new CompletionResponse(this.data.toString(), this.isComplete, isLast);
                this.reset();
                return response;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reset() {
            Object object = this.lock;
            synchronized (object) {
                this.eventName = null;
                this.data = new StringBuilder();
                this.stopReason = null;
                this.isComplete = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setStopReason(String stopReason) {
            Object object = this.lock;
            synchronized (object) {
                this.stopReason = stopReason;
                if (StringUtils.isNotBlank(stopReason) && "stop_sequence".equals(stopReason)) {
                    this.isComplete = true;
                }
            }
        }
    }
}

