/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.batch;

import ai.grakn.util.CommonUtil;
import ai.grakn.util.SimpleURI;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URL;
import javax.ws.rs.core.UriBuilder;

public final class Client {
    public static boolean serverIsRunning(SimpleURI uri) {
        int available;
        HttpURLConnection connection;
        URL url;
        try {
            url = UriBuilder.fromUri((URI)uri.toURI()).path("/kb").build(new Object[0]).toURL();
        }
        catch (MalformedURLException e) {
            throw CommonUtil.unreachableStatement((String)"This will never throw because we're appending a known path to a valid URI", (Throwable)e);
        }
        try {
            connection = (HttpURLConnection)Client.mapQuadZeroRouteToLocalhost(url).openConnection();
        }
        catch (IOException e) {
            return false;
        }
        try {
            connection.setRequestMethod("GET");
        }
        catch (ProtocolException e) {
            throw CommonUtil.unreachableStatement((String)"This will never throw because 'GET' is correct and the connection is not open yet", (Throwable)e);
        }
        try {
            connection.connect();
            InputStream inputStream = connection.getInputStream();
            available = inputStream.available();
        }
        catch (IOException e) {
            return false;
        }
        return available != 0;
    }

    private static URL mapQuadZeroRouteToLocalhost(URL originalUrl) {
        URL mappedUrl;
        String QUAD_ZERO_ROUTE = "http://0.0.0.0";
        if ((originalUrl.getProtocol() + originalUrl.getHost()).equals("http://0.0.0.0")) {
            try {
                mappedUrl = new URL(originalUrl.getProtocol(), "localhost", originalUrl.getPort(), "/kb");
            }
            catch (MalformedURLException e) {
                throw CommonUtil.unreachableStatement((String)"This will never throw because the protocol is valid (because it came from another URL)", (Throwable)e);
            }
        } else {
            mappedUrl = originalUrl;
        }
        return mappedUrl;
    }
}

