/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.client.rpc;

import ai.grakn.client.rpc.AutoValue_Transceiver_Response;
import ai.grakn.exception.GraknTxOperationException;
import ai.grakn.rpc.proto.SessionProto;
import ai.grakn.rpc.proto.SessionServiceGrpc;
import com.google.common.base.Preconditions;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;

public class Transceiver
implements AutoCloseable {
    private final StreamObserver<SessionProto.Transaction.Req> requestSender;
    private final ResponseListener responseListener;

    private Transceiver(StreamObserver<SessionProto.Transaction.Req> requestSender, ResponseListener responseListener) {
        this.requestSender = requestSender;
        this.responseListener = responseListener;
    }

    public static Transceiver create(SessionServiceGrpc.SessionServiceStub stub) {
        ResponseListener responseListener = new ResponseListener();
        StreamObserver<SessionProto.Transaction.Req> requestSender = stub.transaction(responseListener);
        return new Transceiver(requestSender, responseListener);
    }

    public void send(SessionProto.Transaction.Req request) {
        if (this.responseListener.terminated.get()) {
            throw GraknTxOperationException.transactionClosed(null, (String)"The gRPC connection closed");
        }
        this.requestSender.onNext((Object)request);
    }

    public Response receive() throws InterruptedException {
        Response response = this.responseListener.poll();
        if (response.type() != Response.Type.OK) {
            this.close();
        }
        return response;
    }

    @Override
    public void close() {
        try {
            this.requestSender.onCompleted();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.responseListener.close();
    }

    public boolean isClosed() {
        return this.responseListener.terminated.get();
    }

    public static abstract class Response {
        @Nullable
        abstract SessionProto.Transaction.Res nullableOk();

        @Nullable
        abstract StatusRuntimeException nullableError();

        public final Type type() {
            if (this.nullableOk() != null) {
                return Type.OK;
            }
            if (this.nullableError() != null) {
                return Type.ERROR;
            }
            return Type.COMPLETED;
        }

        public final SessionProto.Transaction.Res ok() {
            SessionProto.Transaction.Res response = this.nullableOk();
            if (response == null) {
                throw new IllegalStateException("Expected successful response not found: " + this.toString());
            }
            return response;
        }

        public final StatusRuntimeException error() {
            StatusRuntimeException throwable = this.nullableError();
            if (throwable == null) {
                throw new IllegalStateException("Expected error not found: " + this.toString());
            }
            return throwable;
        }

        private static Response create(@Nullable SessionProto.Transaction.Res response, @Nullable StatusRuntimeException error) {
            Preconditions.checkArgument((response == null || error == null ? 1 : 0) != 0);
            return new AutoValue_Transceiver_Response(response, error);
        }

        static Response completed() {
            return Response.create(null, null);
        }

        static Response error(StatusRuntimeException error) {
            return Response.create(null, error);
        }

        static Response ok(SessionProto.Transaction.Res response) {
            return Response.create(response, null);
        }

        public static enum Type {
            OK,
            ERROR,
            COMPLETED;

        }
    }

    private static class ResponseListener
    implements StreamObserver<SessionProto.Transaction.Res>,
    AutoCloseable {
        private final BlockingQueue<Response> queue = new LinkedBlockingDeque<Response>();
        private final AtomicBoolean terminated = new AtomicBoolean(false);

        private ResponseListener() {
        }

        public void onNext(SessionProto.Transaction.Res value) {
            this.queue.add(Response.ok(value));
        }

        public void onError(Throwable throwable) {
            this.terminated.set(true);
            assert (throwable instanceof StatusRuntimeException) : "The server only yields these exceptions";
            this.queue.add(Response.error((StatusRuntimeException)throwable));
        }

        public void onCompleted() {
            this.terminated.set(true);
            this.queue.add(Response.completed());
        }

        Response poll() throws InterruptedException {
            Response response = (Response)this.queue.poll();
            if (response != null) {
                return response;
            }
            if (this.terminated.get()) {
                throw GraknTxOperationException.transactionClosed(null, (String)"The gRPC connection closed");
            }
            return this.queue.take();
        }

        @Override
        public void close() {
            while (!this.terminated.get()) {
                try {
                    this.poll();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

