/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine;

import ai.grakn.engine.backgroundtasks.distributed.ClusterManager;
import ai.grakn.engine.backgroundtasks.distributed.DistributedTaskManager;
import ai.grakn.engine.controller.AuthController;
import ai.grakn.engine.controller.CommitLogController;
import ai.grakn.engine.controller.GraphFactoryController;
import ai.grakn.engine.controller.ImportController;
import ai.grakn.engine.controller.StatusController;
import ai.grakn.engine.controller.TasksController;
import ai.grakn.engine.controller.UserController;
import ai.grakn.engine.controller.VisualiserController;
import ai.grakn.engine.postprocessing.PostProcessing;
import ai.grakn.engine.postprocessing.PostProcessingTask;
import ai.grakn.engine.session.RemoteSession;
import ai.grakn.engine.util.ConfigProperties;
import ai.grakn.engine.util.JWTHandler;
import ai.grakn.exception.GraknEngineServerException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Filter;
import spark.Request;
import spark.Response;
import spark.Spark;

public class GraknEngineServer {
    private static final ConfigProperties prop = ConfigProperties.getInstance();
    private static final Logger LOG = LoggerFactory.getLogger(GraknEngineServer.class);
    private static final int WEBSOCKET_TIMEOUT = 3600000;
    private static final Set<String> unauthenticatedEndPoints = new HashSet<String>(Arrays.asList("/auth/session/", "/shell/remote", "/graph_factory", "/auth/enabled/"));
    public static final boolean isPasswordProtected = prop.getPropertyAsBool("password.protected");

    public static void main(String[] args) {
        GraknEngineServer.startHTTP();
        GraknEngineServer.startCluster();
        GraknEngineServer.printStartMessage(prop.getProperty("server.host"), prop.getProperty("server.port"), prop.getLogFilePath());
    }

    public static void startHTTP() {
        Spark.ipAddress((String)prop.getProperty("server.host"));
        Spark.port((int)prop.getPropertyAsInt("server.port"));
        Spark.staticFiles.externalLocation(prop.getPath("server.static-file-dir"));
        Spark.webSocket((String)"/shell/remote", RemoteSession.class);
        Spark.webSocketIdleTimeoutMillis((int)3600000);
        new VisualiserController();
        new GraphFactoryController();
        new ImportController();
        new CommitLogController();
        new StatusController();
        new TasksController();
        new AuthController();
        new UserController();
        Spark.before((Filter[])new Filter[]{GraknEngineServer::checkAuthorization});
        Spark.exception(GraknEngineServerException.class, (e, request, response) -> {
            response.status(((GraknEngineServerException)e).getStatus());
            response.body("New exception: " + e.getMessage() + " - Please refer to grakn.log file for full stack trace.");
        });
        Spark.awaitInitialization();
    }

    public static void startCluster() {
        ClusterManager.getInstance().start();
        DistributedTaskManager manager = DistributedTaskManager.getInstance();
        manager.open();
        manager.scheduleTask(new PostProcessingTask(), GraknEngineServer.class.getName(), new Date(), prop.getPropertyAsInt("backgroundTasks.time-lapse"), new JSONObject());
    }

    public static void stopHTTP() {
        Spark.stop();
    }

    public static void stopCluster() {
        DistributedTaskManager.getInstance().close();
        PostProcessing.getInstance().stop();
        ClusterManager.getInstance().stop();
    }

    public static boolean isRunning() {
        try {
            String host = prop.getProperty("server.host");
            String port = prop.getProperty("server.port");
            HttpURLConnection connection = (HttpURLConnection)new URL("http://" + host + ":" + port + "/graph_factory").openConnection();
            connection.setRequestMethod("GET");
            connection.connect();
            InputStream inputStream = connection.getInputStream();
            if (inputStream.available() == 0) {
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private static void checkAuthorization(Request request, Response response) {
        if (!isPasswordProtected) {
            return;
        }
        if (!unauthenticatedEndPoints.contains(request.pathInfo())) {
            boolean authenticated;
            try {
                if (request.headers("Authorization") == null || !request.headers("Authorization").startsWith("Bearer ")) {
                    throw new GraknEngineServerException(400, "Authorization field in header corrupted or absent.");
                }
                String token = request.headers("Authorization").substring(7);
                authenticated = JWTHandler.verifyJWT(token);
            }
            catch (Exception e) {
                throw new GraknEngineServerException(400, e);
            }
            if (!authenticated) {
                Spark.halt((int)401, (String)"User not authenticated.");
            }
        }
    }

    private static void printStartMessage(String host, String port, String logFilePath) {
        String address = "http://" + host + ":" + port;
        LOG.info("\nGrakn LOG file located at [" + logFilePath + "]");
        LOG.info("\n==================================================");
        LOG.info("\n" + String.format("     ___  ___  ___  _  __ _  _     ___  ___     \n    / __|| _ \\/   \\| |/ /| \\| |   /   \\|_ _|    \n   | (_ ||   /| - || ' < | .` | _ | - | | |     \n    \\___||_|_\\|_|_||_|\\_\\|_|\\_|(_)|_|_||___|   \n\n Web Dashboard available at [%s]", address));
        LOG.info("\n==================================================");
    }
}

