/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.backgroundtasks.config;

import ai.grakn.engine.util.ConfigProperties;
import java.util.Properties;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;

public class ConfigHelper {
    public static CuratorFramework client() {
        int sleep = ConfigProperties.getInstance().getPropertyAsInt("tasks.zookeeper.backoff.base_sleep");
        int retries = ConfigProperties.getInstance().getPropertyAsInt("tasks.zookeeper.backoff.max_retries");
        return CuratorFrameworkFactory.builder().connectString(ConfigProperties.getInstance().getProperty("tasks.zookeeper.servers")).namespace("grakn").sessionTimeoutMs(ConfigProperties.getInstance().getPropertyAsInt("tasks.zookeeper.session_timeout_ms")).connectionTimeoutMs(ConfigProperties.getInstance().getPropertyAsInt("tasks.zookeeper.connection_timeout_ms")).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(sleep, retries)).build();
    }

    public static <K, V> KafkaConsumer<K, V> kafkaConsumer(String groupId) {
        Properties properties = new Properties();
        properties.put("bootstrap.servers", ConfigProperties.getInstance().getProperty("tasks.kafka.bootstrap-servers"));
        properties.put("group.id", groupId);
        properties.put("enable.auto.commit", (Object)false);
        properties.put("session.timeout.ms", ConfigProperties.getInstance().getProperty("tasks.kafka.consumer.session-timeout"));
        properties.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        properties.put("value.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        return new KafkaConsumer(properties);
    }

    public static <K, V> KafkaProducer<K, V> kafkaProducer() {
        Properties properties = new Properties();
        properties.put("bootstrap.servers", ConfigProperties.getInstance().getProperty("tasks.kafka.bootstrap-servers"));
        properties.put("acks", "all");
        properties.put("retries", (Object)ConfigProperties.getInstance().getPropertyAsInt("tasks.kafka.producer.retries"));
        properties.put("batch.size", (Object)ConfigProperties.getInstance().getPropertyAsInt("tasks.kafka.producer.batch-size"));
        properties.put("linger.ms", (Object)ConfigProperties.getInstance().getPropertyAsInt("tasks.kafka.producer.linger-ms"));
        properties.put("buffer.memory", (Object)ConfigProperties.getInstance().getPropertyAsInt("tasks.kafka.producer.buffer-mem"));
        properties.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        properties.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        return new KafkaProducer(properties);
    }
}

