/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.backgroundtasks.distributed;

import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaLogger {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaLogger.class);
    private final LogLevel logLevel = LogLevel.DEBUG;
    private static KafkaLogger instance = null;
    private KafkaProducer<String, String> producer;

    public static synchronized KafkaLogger getInstance() {
        if (instance == null) {
            instance = new KafkaLogger();
        }
        return instance;
    }

    public void debug(String msg) {
        if (this.logLevel.level() <= LogLevel.DEBUG.level()) {
            this.sendMsg(LogLevel.DEBUG.toString(), Thread.currentThread().getStackTrace()[2].toString(), msg);
        }
        LOG.debug(msg);
    }

    public void info(String msg) {
        if (this.logLevel.level() <= LogLevel.INFO.level()) {
            this.sendMsg(LogLevel.INFO.toString(), Thread.currentThread().getStackTrace()[2].toString(), msg);
        }
        LOG.info(msg);
    }

    public void warn(String msg) {
        if (this.logLevel.level() <= LogLevel.WARN.level()) {
            this.sendMsg(LogLevel.WARN.toString(), Thread.currentThread().getStackTrace()[2].toString(), msg);
        }
        LOG.warn(msg);
    }

    public void error(String msg) {
        if (this.logLevel.level() <= LogLevel.ERROR.level()) {
            this.sendMsg(LogLevel.ERROR.toString(), Thread.currentThread().getStackTrace()[2].toString(), msg);
        }
        LOG.error(msg);
    }

    public void error(String msg, Throwable ex) {
        if (this.logLevel.level() <= LogLevel.ERROR.level()) {
            this.sendMsg(LogLevel.ERROR.toString(), Thread.currentThread().getStackTrace()[2].toString(), msg + "\n" + ExceptionUtils.getFullStackTrace((Throwable)ex));
        }
        LOG.error(msg);
    }

    private KafkaLogger() {
    }

    private void sendMsg(String level, String caller, String msg) {
    }

    private static enum LogLevel {
        DEBUG("DEBUG", 0),
        INFO("INFO", 1),
        WARN("WARN", 2),
        ERROR("ERROR", 3);

        private final int level;
        private final String value;

        private LogLevel(String value, int level) {
            this.value = value;
            this.level = level;
        }

        public String toString() {
            return this.value;
        }

        public int level() {
            return this.level;
        }
    }
}

