/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.backgroundtasks.taskstorage;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.Entity;
import ai.grakn.concept.Instance;
import ai.grakn.concept.Resource;
import ai.grakn.concept.ResourceType;
import ai.grakn.concept.RoleType;
import ai.grakn.engine.backgroundtasks.StateStorage;
import ai.grakn.engine.backgroundtasks.TaskState;
import ai.grakn.engine.backgroundtasks.TaskStatus;
import ai.grakn.engine.backgroundtasks.distributed.KafkaLogger;
import ai.grakn.exception.GraknBackendException;
import ai.grakn.factory.GraphFactory;
import ai.grakn.graql.Graql;
import ai.grakn.graql.InsertQuery;
import ai.grakn.graql.MatchQuery;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.Var;
import ai.grakn.util.Schema;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javafx.util.Pair;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.json.JSONObject;

public class GraknStateStorage
implements StateStorage {
    private static final String TASK_VAR = "task";
    private static final int retries = 10;
    private final KafkaLogger LOG = KafkaLogger.getInstance();

    @Override
    public String newState(String taskName, String createdBy, Date runAt, Boolean recurring, long interval, JSONObject configuration) {
        if (taskName == null || createdBy == null || runAt == null || recurring == null) {
            return null;
        }
        Var state = Graql.var((String)TASK_VAR).isa("scheduled-task").has("status", (Object)TaskStatus.CREATED.toString()).has("task-class-name", (Object)taskName).has("created-by", (Object)createdBy).has("run-at", (Object)runAt.getTime()).has("recurring", (Object)recurring).has("recur-interval", (Object)interval);
        if (configuration != null) {
            state.has("task-configuration", (Object)configuration.toString());
        }
        Optional<String> result = this.attemptCommitToSystemGraph(graph -> {
            InsertQuery query = graph.graql().insert(new Var[]{state});
            ConceptId id = ((Concept)((Map)query.stream().findFirst().get()).get(TASK_VAR)).getId();
            this.LOG.debug("Created " + graph.getConcept(id));
            return id.getValue();
        }, true);
        return result.map(x -> x).orElse(null);
    }

    @Override
    public Boolean updateState(String id, TaskStatus status, String statusChangeBy, String engineID, Throwable failure, String checkpoint, JSONObject configuration) {
        if (id == null) {
            return false;
        }
        if (status == null && statusChangeBy == null && engineID == null && failure == null && checkpoint == null && configuration == null) {
            return false;
        }
        HashSet<String> resourcesToDettach = new HashSet<String>();
        Var resources = Graql.var((String)TASK_VAR).id(ConceptId.of((String)id));
        if (status != null) {
            resourcesToDettach.add("status");
            resourcesToDettach.add("status-change-time");
            resources.has("status", (Object)status.toString()).has("status-change-time", (Object)new Date().getTime());
        }
        if (statusChangeBy != null) {
            resourcesToDettach.add("status-change-by");
            resources.has("status-change-by", (Object)statusChangeBy);
        }
        if (engineID != null) {
            resourcesToDettach.add("engine-id");
            resources.has("engine-id", (Object)engineID);
        }
        if (failure != null) {
            resourcesToDettach.add("task-exception");
            resourcesToDettach.add("stack-trace");
            resources.has("task-exception", (Object)failure.toString());
            if (failure.getStackTrace().length > 0) {
                resources.has("stack-trace", (Object)Arrays.toString(failure.getStackTrace()));
            }
        }
        if (checkpoint != null) {
            resourcesToDettach.add("task-checkpoint");
            resources.has("task-checkpoint", (Object)checkpoint);
        }
        if (configuration != null) {
            resourcesToDettach.add("task-configuration");
            resources.has("task-configuration", (Object)configuration.toString());
        }
        Optional<Boolean> result = this.attemptCommitToSystemGraph(graph -> {
            this.LOG.debug("dettaching: " + resourcesToDettach);
            this.LOG.debug("inserting " + resources);
            Entity task = (Entity)graph.getConcept(ConceptId.of((String)id));
            resourcesToDettach.forEach(typeName -> {
                RoleType roleType = graph.getRoleType(Schema.Resource.HAS_RESOURCE_OWNER.getName(typeName));
                if (roleType == null) {
                    System.err.println("NO ROLE TYPE FOR RESOURCE " + typeName);
                }
                task.relations(new RoleType[]{roleType}).forEach(Concept::delete);
            });
            graph.graql().insert(new Var[]{resources}).execute();
            return true;
        }, true);
        return result.isPresent();
    }

    @Override
    public TaskState getState(String id) {
        if (id == null) {
            return null;
        }
        Optional<TaskState> result = this.attemptCommitToSystemGraph(graph -> {
            Instance instance = (Instance)graph.getConcept(ConceptId.of((String)id));
            return this.instanceToState((GraknGraph)graph, instance);
        }, false);
        return result.get();
    }

    private TaskState instanceToState(GraknGraph graph, Instance instance) {
        Resource name = instance.resources(new ResourceType[]{graph.getResourceType("task-class-name")}).stream().findFirst().orElse(null);
        if (name == null) {
            this.LOG.error("Could not get 'task-class-name' for " + instance.getId());
            return null;
        }
        TaskState state = new TaskState(name.getValue().toString());
        List resources = (List)graph.graql().match(new Pattern[]{Graql.var().rel(Graql.var().id(instance.getId())).rel(Graql.var((String)"r").isa(Graql.var().sub("resource")))}).select(new String[]{"r"}).execute();
        resources.forEach(x -> x.values().forEach(y -> {
            Resource r = y.asResource();
            this.buildState(state, r.type().getName(), r.getValue());
        }));
        return state;
    }

    @Override
    public Set<Pair<String, TaskState>> getTasks(TaskStatus taskStatus, String taskClassName, String createdBy, int limit, int offset) {
        return this.getTasks(taskStatus, taskClassName, createdBy, limit, offset, false);
    }

    public Set<Pair<String, TaskState>> getTasks(TaskStatus taskStatus, String taskClassName, String createdBy, int limit, int offset, Boolean recurring) {
        Optional<Set> result;
        Var matchVar = Graql.var((String)TASK_VAR).isa("scheduled-task");
        if (taskStatus != null) {
            matchVar.has("status", (Object)taskStatus.toString());
        }
        if (taskClassName != null) {
            matchVar.has("task-class-name", (Object)taskClassName);
        }
        if (createdBy != null) {
            matchVar.has("created-by", (Object)createdBy);
        }
        if (recurring != null) {
            matchVar.has("recurring", (Object)recurring);
        }
        return (result = this.attemptCommitToSystemGraph(graph -> {
            MatchQuery q = graph.graql().match(new Pattern[]{matchVar});
            if (limit > 0) {
                q.limit((long)limit);
            }
            if (offset > 0) {
                q.offset((long)offset);
            }
            List res = (List)q.execute();
            HashSet<Pair> out = new HashSet<Pair>();
            for (Map m : res) {
                Concept c = m.values().stream().findFirst().orElse(null);
                if (c == null) continue;
                String id = c.getId().getValue();
                out.add(new Pair((Object)id, (Object)this.instanceToState((GraknGraph)graph, c.asInstance())));
            }
            return out;
        }, false)).isPresent() ? result.get() : new HashSet();
    }

    private TaskState buildState(TaskState state, String resourceName, Object resourceValue) {
        switch (resourceName) {
            case "status": {
                state.status(TaskStatus.valueOf(resourceValue.toString()));
                break;
            }
            case "status-change-time": {
                state.statusChangeTime(new Date((Long)resourceValue));
                break;
            }
            case "status-change-by": {
                state.statusChangedBy(resourceValue.toString());
                break;
            }
            case "task-class-name": {
                break;
            }
            case "created-by": {
                state.creator(resourceValue.toString());
                break;
            }
            case "engine-id": {
                state.engineID(resourceValue.toString());
                break;
            }
            case "run-at": {
                state.runAt(new Date((Long)resourceValue));
                break;
            }
            case "recurring": {
                state.isRecurring((Boolean)resourceValue);
                break;
            }
            case "recur-interval": {
                state.interval((Long)resourceValue);
                break;
            }
            case "task-exception": {
                state.exception(resourceValue.toString());
                break;
            }
            case "stack-trace": {
                state.stackTrace(resourceValue.toString());
                break;
            }
            case "task-checkpoint": {
                state.checkpoint(resourceValue.toString());
                break;
            }
            case "task-configuration": {
                state.configuration(new JSONObject(resourceValue.toString()));
                break;
            }
            default: {
                this.LOG.error("Unknown resource type when deserialising TaskState: " + resourceName);
            }
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private synchronized <T> Optional<T> attemptCommitToSystemGraph(Function<GraknGraph, T> function, boolean commit) {
        double sleepFor = 100.0;
        for (int i = 0; i < 10; ++i) {
            Optional<T> optional;
            Throwable throwable;
            GraknGraph graph2222;
            long time;
            block25: {
                block26: {
                    this.LOG.debug("Attempting " + (commit ? "commit" : "query") + " on system graph @ t" + Thread.currentThread().getId());
                    time = System.currentTimeMillis();
                    graph2222 = GraphFactory.getInstance().getGraph("graknSystem");
                    throwable = null;
                    T result = function.apply(graph2222);
                    if (commit) {
                        graph2222.commit();
                    }
                    optional = Optional.of(result);
                    if (graph2222 == null) break block25;
                    if (throwable == null) break block26;
                    try {
                        graph2222.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block25;
                }
                graph2222.close();
            }
            this.LOG.debug("Took " + (System.currentTimeMillis() - time) + " to " + (commit ? "commit" : "query") + " to system graph @ t" + Thread.currentThread().getId());
            return optional;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (graph2222 != null) {
                            if (throwable != null) {
                                try {
                                    graph2222.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                graph2222.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (GraknBackendException graph2222) {
                    this.LOG.debug("Took " + (System.currentTimeMillis() - time) + " to " + (commit ? "commit" : "query") + " to system graph @ t" + Thread.currentThread().getId());
                }
                catch (Throwable e) {
                    try {
                        e.printStackTrace(System.err);
                        this.LOG.error("Failed to validate the graph when updating the state " + ExceptionUtils.getFullStackTrace((Throwable)e));
                        this.LOG.debug("Took " + (System.currentTimeMillis() - time) + " to " + (commit ? "commit" : "query") + " to system graph @ t" + Thread.currentThread().getId());
                        break;
                    }
                    catch (Throwable throwable6) {
                        this.LOG.debug("Took " + (System.currentTimeMillis() - time) + " to " + (commit ? "commit" : "query") + " to system graph @ t" + Thread.currentThread().getId());
                        throw throwable6;
                    }
                }
            }
            try {
                Thread.sleep((long)sleepFor);
                continue;
            }
            catch (InterruptedException e) {
                this.LOG.error(ExceptionUtils.getFullStackTrace((Throwable)e));
                continue;
            }
            finally {
                sleepFor = 0.5 * (Math.pow(2.0, i) - 1.0);
            }
        }
        return Optional.empty();
    }
}

