/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.backgroundtasks.taskstorage;

import ai.grakn.engine.backgroundtasks.TaskStatus;
import ai.grakn.engine.backgroundtasks.config.ConfigHelper;
import ai.grakn.engine.backgroundtasks.distributed.KafkaLogger;
import ai.grakn.engine.backgroundtasks.taskstorage.SynchronizedState;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.curator.framework.CuratorFramework;

public class SynchronizedStateStorage {
    private final KafkaLogger LOG = KafkaLogger.getInstance();
    private static SynchronizedStateStorage instance = null;
    private final CuratorFramework zookeeperConnection = ConfigHelper.client();

    private SynchronizedStateStorage() throws Exception {
        this.zookeeperConnection.start();
        this.zookeeperConnection.blockUntilConnected();
        this.createZKPaths();
    }

    public static synchronized SynchronizedStateStorage getInstance() throws Exception {
        if (instance == null) {
            instance = new SynchronizedStateStorage();
        }
        return instance;
    }

    public CuratorFramework connection() {
        return this.zookeeperConnection;
    }

    public void close() {
        this.zookeeperConnection.close();
        instance = null;
    }

    public void newState(String id, TaskStatus status, String engineID, String checkpoint) throws Exception {
        if (id == null || status == null) {
            return;
        }
        SynchronizedState state = new SynchronizedState(status);
        if (engineID != null) {
            state.engineID(engineID);
        }
        if (checkpoint != null) {
            state.checkpoint(checkpoint);
        }
        this.zookeeperConnection.create().creatingParentContainersIfNeeded().forPath("/tasks/" + id + "/state", state.serialize().getBytes());
    }

    public Boolean updateState(String id, TaskStatus status, String engineID, String checkpoint) {
        if (id == null) {
            return false;
        }
        if (status == null && engineID == null && checkpoint == null) {
            return false;
        }
        try {
            SynchronizedState state = this.getState(id);
            if (state == null) {
                return false;
            }
            if (status != null) {
                state.status(status);
            }
            if (engineID != null) {
                state.engineID(engineID);
            }
            if (checkpoint != null) {
                state.checkpoint(checkpoint);
            }
            this.zookeeperConnection.setData().forPath("/tasks/" + id + "/state", state.serialize().getBytes());
        }
        catch (Exception e) {
            this.LOG.error("Could not write to ZooKeeper! - " + e);
            return false;
        }
        return true;
    }

    public SynchronizedState getState(String id) {
        try {
            byte[] b = (byte[])this.zookeeperConnection.getData().forPath("/tasks/" + id + "/state");
            return SynchronizedState.deserialize(new String(b));
        }
        catch (Exception e) {
            this.LOG.error(" Could not read from ZooKeeper! " + ExceptionUtils.getFullStackTrace((Throwable)e));
            return null;
        }
    }

    private void createZKPaths() throws Exception {
        if (this.zookeeperConnection.checkExists().forPath("/scheduler") == null) {
            this.zookeeperConnection.create().creatingParentContainersIfNeeded().forPath("/scheduler");
        }
        if (this.zookeeperConnection.checkExists().forPath("/task_runners/watch") == null) {
            this.zookeeperConnection.create().creatingParentContainersIfNeeded().forPath("/task_runners/watch");
        }
        if (this.zookeeperConnection.checkExists().forPath("/task_runners/last_state") == null) {
            this.zookeeperConnection.create().creatingParentContainersIfNeeded().forPath("/task_runners/last_state");
        }
        if (this.zookeeperConnection.checkExists().forPath("/tasks") == null) {
            this.zookeeperConnection.create().creatingParentContainersIfNeeded().forPath("/tasks");
        }
    }
}

