/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.controller;

import ai.grakn.engine.user.UsersHandler;
import ai.grakn.engine.util.ConfigProperties;
import ai.grakn.engine.util.JWTHandler;
import ai.grakn.exception.GraknEngineServerException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import mjson.Json;
import spark.Request;
import spark.Response;
import spark.Spark;

@Path(value="/auth")
@Api(value="/graph", description="Endpoints used to handle operations related to authentication.")
@Produces(value={"application/json", "text/plain"})
public class AuthController {
    private static final UsersHandler usersHandler = UsersHandler.getInstance();
    private static final String USERNAME_KEY = "username";
    private static final String PASSWORD_KEY = "password";

    public AuthController() {
        Spark.post((String)"/auth/session/", this::newSession);
        Spark.get((String)"/auth/enabled/", this::isPasswordProtected);
    }

    @POST
    @Path(value="/session")
    @ApiOperation(value="If a given user/password pair is valid, returns a new JWT")
    @ApiImplicitParams(value={@ApiImplicitParam(name="username", value="Username", required=true, dataType="string", paramType="body"), @ApiImplicitParam(name="password", value="Password", required=true, dataType="string", paramType="body")})
    private String newSession(Request req, Response res) {
        String password;
        String user;
        try {
            Json jsonBody = Json.read((String)req.body());
            user = jsonBody.at(USERNAME_KEY).asString();
            password = jsonBody.at(PASSWORD_KEY).asString();
        }
        catch (Exception e) {
            throw new GraknEngineServerException(400, e);
        }
        if (usersHandler.validateUser(user, password)) {
            return JWTHandler.signJWT(user);
        }
        throw new GraknEngineServerException(401, "Wrong authentication parameters have been provided.");
    }

    @GET
    @Path(value="/enabled")
    @ApiOperation(value="Returns true if Engine endpoints are password protected. False otherwise.")
    private String isPasswordProtected(Request req, Response res) {
        return ConfigProperties.getInstance().getProperty("password.protected");
    }
}

