/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.controller;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Entity;
import ai.grakn.concept.Resource;
import ai.grakn.concept.ResourceType;
import ai.grakn.engine.util.ConfigProperties;
import ai.grakn.exception.GraknEngineServerException;
import ai.grakn.factory.GraphFactory;
import ai.grakn.util.ErrorMessage;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collection;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import mjson.Json;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Request;
import spark.Response;
import spark.Spark;

public class GraphFactoryController {
    private final Logger LOG = LoggerFactory.getLogger(GraphFactoryController.class);

    public GraphFactoryController() {
        Spark.get((String)"/graph_factory", this::getGraphConfig);
        Spark.get((String)"/keyspaces", this::getKeySpaces);
    }

    @GET
    @Path(value="/graph_factory")
    @ApiOperation(value="Get config which is used to build graphs")
    @ApiImplicitParam(name="graphConfig", value="The type of graph config to return", required=true, dataType="string", paramType="path")
    private String getGraphConfig(Request request, Response response) {
        String graphConfig = request.queryParams("graphConfig");
        ConfigProperties prop = ConfigProperties.getInstance();
        try {
            if (graphConfig == null) {
                graphConfig = "graphdatabase.config";
            } else {
                switch (graphConfig) {
                    case "default": {
                        graphConfig = "graphdatabase.config";
                        break;
                    }
                    case "computer": {
                        graphConfig = "graphdatabase.computer";
                    }
                }
            }
            return new String(Files.readAllBytes(Paths.get(prop.getPath(graphConfig), new String[0])));
        }
        catch (IOException e) {
            throw new GraknEngineServerException(500, ErrorMessage.NO_CONFIG_FILE.getMessage(new Object[]{prop.getPath(graphConfig)}));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="/keyspaces")
    @ApiOperation(value="Get all the key spaces that have been opened")
    private String getKeySpaces(Request request, Response response) {
        try (GraknGraph graph = GraphFactory.getInstance().getGraph("graknSystem");){
            ResourceType keyspaceName = graph.getResourceType("keyspace-name");
            Json result = Json.array();
            if (graph.getEntityType("keyspace") == null) {
                this.LOG.warn("No system ontology in system keyspace, possibly a bug!");
                String string = result.toString();
                return string;
            }
            for (Entity keyspace : graph.getEntityType("keyspace").instances()) {
                Collection names = keyspace.resources(new ResourceType[]{keyspaceName});
                if (names.size() != 1) {
                    throw new GraknEngineServerException(500, ErrorMessage.INVALID_SYSTEM_KEYSPACE.getMessage(new Object[]{" keyspace " + keyspace.getId() + " hos no unique name."}));
                }
                result.add(((Resource)names.iterator().next()).getValue());
            }
            String string = result.toString();
            return string;
        }
        catch (Exception e) {
            this.LOG.error("While retrieving keyspace list:", (Throwable)e);
            throw e;
        }
    }
}

