/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.controller;

import ai.grakn.engine.controller.Utilities;
import ai.grakn.engine.loader.Loader;
import ai.grakn.engine.postprocessing.PostProcessing;
import ai.grakn.exception.GraknEngineServerException;
import ai.grakn.graql.Graql;
import ai.grakn.graql.QueryBuilder;
import ai.grakn.graql.Var;
import ai.grakn.graql.internal.parser.QueryParser;
import ai.grakn.util.ErrorMessage;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Request;
import spark.Response;
import spark.Spark;

@Api(value="/import", description="Endpoints to import Graql data from a file.")
@Path(value="/import")
@Produces(value={"text/plain"})
public class ImportController {
    private final Logger LOG = LoggerFactory.getLogger(ImportController.class);
    private final AtomicBoolean loadingInProgress = new AtomicBoolean(false);
    private static final String INSERT_KEYWORD = "insert";
    private static final String MATCH_KEYWORD = "match";

    public ImportController() {
        Spark.before((String)"/import/batch/data", (req, res) -> {
            if (this.loadingInProgress.get()) {
                Spark.halt((int)423, (String)"Another loading process is still running.\n");
            }
        });
        Spark.post((String)"/import/batch/data", this::importDataREST);
    }

    @POST
    @Path(value="/batch/data")
    @ApiOperation(value="Import data from a Graql file. It performs batch loading.", notes="If the hosts field is populated, it will distribute the load amongst them. This should not be used to load ontologies because it splits up the file into smaller parts.")
    @ApiImplicitParams(value={@ApiImplicitParam(name="path", value="File path on the server.", required=true, dataType="string", paramType="body"), @ApiImplicitParam(name="keyspace", value="Name of graph to use", dataType="string", paramType="query")})
    private String importDataREST(Request req, Response res) {
        try {
            String keyspace = Utilities.getKeyspace(req);
            String pathToFile = Utilities.getAsString("path", req.body());
            File file = new File(pathToFile);
            if (!file.exists()) {
                throw new FileNotFoundException(ErrorMessage.NO_GRAQL_FILE.getMessage(new Object[]{pathToFile}));
            }
            Loader loader = this.getLoader(keyspace);
            ScheduledFuture scheduledFuture = this.scheduledPrinting(loader);
            Executors.newSingleThreadExecutor().submit(() -> this.importDataFromFile(file, loader, scheduledFuture));
        }
        catch (FileNotFoundException j) {
            throw new GraknEngineServerException(400, (Exception)j);
        }
        catch (Exception e) {
            throw new GraknEngineServerException(500, e);
        }
        return "Loading successfully STARTED.\n";
    }

    private Loader getLoader(String keyspace) {
        return new Loader(keyspace);
    }

    private ScheduledFuture scheduledPrinting(Loader loader) {
        return Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(loader::printLoaderState, 10L, 10L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importDataFromFile(File file, Loader loaderParam, Future statusPrinter) {
        this.LOG.info("Data loading started.");
        this.loadingInProgress.set(true);
        try {
            Iterator<Object> batchIterator = QueryParser.create((QueryBuilder)Graql.withoutGraph()).parseBatchLoad((InputStream)new FileInputStream(file)).iterator();
            if (batchIterator.hasNext()) {
                Object var = batchIterator.next();
                while (var.equals(INSERT_KEYWORD)) {
                    var = this.consumeInsertEntity(batchIterator, loaderParam);
                }
                loaderParam.waitToFinish();
                while (var.equals(MATCH_KEYWORD)) {
                    var = this.consumeInsertRelation(batchIterator, loaderParam);
                }
                loaderParam.waitToFinish();
            }
            PostProcessing.getInstance().run();
        }
        catch (Exception e) {
            this.LOG.error("Exception while batch loading data.", (Throwable)e);
        }
        finally {
            statusPrinter.cancel(true);
            this.loadingInProgress.set(false);
        }
    }

    private Object consumeInsertEntity(Iterator<Object> batchIterator, Loader loader) {
        Object var = null;
        ArrayList<Var> insertQuery = new ArrayList<Var>();
        while (batchIterator.hasNext() && (var = batchIterator.next()) instanceof Var) {
            insertQuery.add((Var)var);
        }
        loader.add(Graql.insert(insertQuery));
        return var;
    }

    private Object consumeInsertRelation(Iterator<Object> batchIterator, Loader loader) {
        Object var = null;
        ArrayList<Var> insertQueryMatch = new ArrayList<Var>();
        while (batchIterator.hasNext() && (var = batchIterator.next()) instanceof Var) {
            insertQueryMatch.add((Var)var);
        }
        if (!var.equals(INSERT_KEYWORD)) {
            throw new GraknEngineServerException(500, "Match statement not followed by any Insert.");
        }
        ArrayList<Var> insertQuery = new ArrayList<Var>();
        while (batchIterator.hasNext() && (var = batchIterator.next()) instanceof Var) {
            insertQuery.add((Var)var);
        }
        loader.add(Graql.match(insertQueryMatch).insert(insertQuery));
        return var;
    }
}

