/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.controller;

import ai.grakn.engine.backgroundtasks.BackgroundTask;
import ai.grakn.engine.backgroundtasks.StateStorage;
import ai.grakn.engine.backgroundtasks.TaskManager;
import ai.grakn.engine.backgroundtasks.TaskState;
import ai.grakn.engine.backgroundtasks.TaskStatus;
import ai.grakn.engine.util.ConfigProperties;
import ai.grakn.exception.GraknEngineServerException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import javafx.util.Pair;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Request;
import spark.Response;
import spark.Spark;

@Path(value="/tasks")
@Api(value="/tasks", description="Endpoints used to query and control queued background tasks.", produces="application/json")
public class TasksController {
    private final Logger LOG = LoggerFactory.getLogger(TasksController.class);
    private TaskManager taskManager;
    private StateStorage stateStorage;

    public TasksController() {
        String mgr = ConfigProperties.getInstance().getProperty("tasks.task-manager", "ai.grakn.engine.backgroundtasks.distributed.DistributedTaskManager");
        try {
            Class<?> cl = Class.forName(mgr);
            this.taskManager = (TaskManager)cl.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            this.taskManager.open();
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            this.LOG.error("Could not start TasksController due to exception (possibly bad configuration) - " + ExceptionUtils.getFullStackTrace((Throwable)e));
            throw new RuntimeException(e);
        }
        this.stateStorage = this.taskManager.storage();
        Spark.get((String)"/tasks/all", this::getTasks);
        Spark.get((String)"/tasks/:id", this::getTask);
        Spark.put((String)"/tasks/:id/stop", this::stopTask);
        Spark.post((String)"/tasks/schedule", this::scheduleTask);
    }

    @GET
    @Path(value="/all")
    @ApiOperation(value="Get tasks matching a specific TaskStatus.")
    @ApiImplicitParams(value={@ApiImplicitParam(name="status", value="TaskStatus as string.", dataType="string", paramType="query"), @ApiImplicitParam(name="className", value="Class name of BackgroundTask Object.", dataType="string", paramType="query"), @ApiImplicitParam(name="creator", value="Who instantiated these tasks.", dataType="string", paramType="query"), @ApiImplicitParam(name="limit", value="Limit the number of entries in the returned result.", dataType="integer", paramType="query"), @ApiImplicitParam(name="offset", value="Use in conjunction with limit for pagination.", dataType="integer", paramType="query")})
    private JSONArray getTasks(Request request, Response response) {
        TaskStatus status = null;
        String className = request.queryParams("className");
        String creator = request.queryParams("creator");
        int limit = 0;
        int offset = 0;
        if (request.queryParams("limit") != null) {
            limit = Integer.valueOf(request.queryParams("limit"));
        }
        if (request.queryParams("offset") != null) {
            offset = Integer.valueOf(request.queryParams("offset"));
        }
        if (request.queryParams("status") != null) {
            status = TaskStatus.valueOf(request.queryParams("status"));
        }
        JSONArray result = new JSONArray();
        for (Pair<String, TaskState> pair : this.stateStorage.getTasks(status, className, creator, limit, offset)) {
            result.put((Object)this.serialiseStateSubset((String)pair.getKey(), (TaskState)pair.getValue()));
        }
        response.type("application/json");
        return result;
    }

    @GET
    @Path(value="/:uuid")
    @ApiOperation(value="Get the state of a specific task by its ID.", produces="application/json")
    @ApiImplicitParam(name="uuid", value="ID of task.", required=true, dataType="string", paramType="path")
    private String getTask(Request request, Response response) {
        try {
            String id = request.params(":id");
            JSONObject result = this.serialiseStateFull(id, this.stateStorage.getState(id));
            response.type("application/json");
            return result.toString();
        }
        catch (Exception e) {
            throw new GraknEngineServerException(500, e);
        }
    }

    @PUT
    @Path(value="/:uuid/stop")
    @ApiOperation(value="Stop a running or paused task.")
    @ApiImplicitParam(name="uuid", value="ID of task.", required=true, dataType="string", paramType="path")
    private String stopTask(Request request, Response response) {
        try {
            String id = request.params(":id");
            this.taskManager.stopTask(id, this.getClass().getName());
            return "";
        }
        catch (Exception e) {
            throw new GraknEngineServerException(500, e);
        }
    }

    @POST
    @Path(value="/schedule")
    @ApiOperation(value="Schedule a task.")
    @ApiImplicitParams(value={@ApiImplicitParam(name="className", value="Class name of object implementing the BackgroundTask interface", required=true, dataType="string", paramType="query"), @ApiImplicitParam(name="createdBy", value="String representing the user scheduling this task", required=true, dataType="string", paramType="query"), @ApiImplicitParam(name="runAt", value="Time to run at as milliseconds since the UNIX epoch", required=true, dataType="long", paramType="query"), @ApiImplicitParam(name="interval", value="If set the task will be marked as recurring and the value will be the time in milliseconds between repeated executions of this task. Value should be as Long.", dataType="long", paramType="query"), @ApiImplicitParam(name="configuration", value="JSON Object that will be given to the task as configuration.", dataType="String", paramType="body")})
    private String scheduleTask(Request request, Response response) {
        String className = request.queryParams("className");
        String createdBy = request.queryParams("creator");
        String runAt = request.queryParams("runAt");
        Long interval = 0L;
        JSONObject configuration = new JSONObject();
        if (request.queryParams("interval") != null) {
            interval = Long.valueOf(request.queryParams("interval"));
        }
        if (className == null || createdBy == null || runAt == null) {
            throw new GraknEngineServerException(400, "Missing mandatory parameters");
        }
        try {
            if (request.body() != null && !request.body().isEmpty()) {
                configuration = new JSONObject(request.body());
            }
            Date runAtDate = new Date(Long.valueOf(runAt));
            Class<?> clazz = Class.forName(className);
            BackgroundTask task = (BackgroundTask)clazz.newInstance();
            String id = this.taskManager.scheduleTask(task, createdBy, runAtDate, interval, configuration);
            JSONObject resp = new JSONObject().put("id", (Object)id);
            response.type("application/json");
            return resp.toString();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new GraknEngineServerException(400, (Exception)e);
        }
        catch (NullPointerException e) {
            throw new GraknEngineServerException(400, "Missing mandatory parameters");
        }
        catch (Exception e) {
            this.LOG.error(ExceptionUtils.getFullStackTrace((Throwable)e));
            throw new GraknEngineServerException(500, e);
        }
    }

    private JSONObject serialiseStateSubset(String id, TaskState state) {
        return new JSONObject().put("id", (Object)id).put("status", (Object)state.status()).put("creator", (Object)state.creator()).put("className", (Object)state.taskClassName()).put("runAt", (Object)state.runAt()).put("recurring", (Object)state.isRecurring());
    }

    private JSONObject serialiseStateFull(String id, TaskState state) {
        return this.serialiseStateSubset(id, state).put("interval", state.interval()).put("exception", (Object)state.exception()).put("stackTrace", (Object)state.stackTrace()).put("engineID", (Object)state.engineID()).put("configuration", (Object)state.configuration());
    }
}

