/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.controller;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.ResourceType;
import ai.grakn.concept.Type;
import ai.grakn.engine.controller.Utilities;
import ai.grakn.engine.util.ConfigProperties;
import ai.grakn.exception.GraknEngineServerException;
import ai.grakn.factory.GraphFactory;
import ai.grakn.graql.AggregateQuery;
import ai.grakn.graql.ComputeQuery;
import ai.grakn.graql.MatchQuery;
import ai.grakn.graql.Query;
import ai.grakn.graql.QueryBuilder;
import ai.grakn.graql.analytics.PathQuery;
import ai.grakn.graql.internal.hal.HALConceptRepresentationBuilder;
import ai.grakn.graql.internal.printer.Printers;
import ai.grakn.graql.internal.reasoner.Reasoner;
import ai.grakn.util.ErrorMessage;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import mjson.Json;
import org.json.JSONArray;
import org.json.JSONObject;
import spark.Request;
import spark.Response;
import spark.Spark;

@Path(value="/graph")
@Api(value="/graph", description="Endpoints used to query the graph by ID or Graql match query and build HAL objects.")
@Produces(value={"application/json", "text/plain"})
public class VisualiserController {
    private static final ConfigProperties properties = ConfigProperties.getInstance();
    private static final int separationDegree = properties.getPropertyAsInt("halBuilder.degree");
    private static final String COMPUTE_RESPONSE_TYPE = "type";
    private static final String COMPUTE_RESPONSE_FIELD = "response";

    public VisualiserController() {
        Spark.get((String)"/graph/concept/:id", this::conceptById);
        Spark.get((String)"/graph/concept/ontology/:id", this::conceptByIdOntology);
        Spark.get((String)"/graph/ontology", this::ontology);
        Spark.get((String)"/graph/match", this::match);
        Spark.get((String)"/graph/analytics", this::compute);
        Spark.get((String)"/graph/preMaterialiseAll", this::preMaterialiseAll);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="/concept/:uuid")
    @ApiOperation(value="Return the HAL representation of a given concept.")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="ID of the concept", required=true, dataType="string", paramType="path"), @ApiImplicitParam(name="keyspace", value="Name of graph to use", dataType="string", paramType="query")})
    private String conceptById(Request req, Response res) {
        String keyspace = Utilities.getKeyspace(req);
        try (GraknGraph graph = GraphFactory.getInstance().getGraph(keyspace);){
            Concept concept = graph.getConcept(ConceptId.of((String)req.params(":id")));
            if (concept == null) {
                throw new GraknEngineServerException(500, ErrorMessage.NO_CONCEPT_IN_KEYSPACE.getMessage(new Object[]{req.params(":id"), keyspace}));
            }
            String string = HALConceptRepresentationBuilder.renderHALConceptData((Concept)concept, (int)separationDegree, (String)keyspace);
            return string;
        }
        catch (Exception e) {
            throw new GraknEngineServerException(500, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="/concept/ontology/:uuid")
    @ApiOperation(value="Return the HAL representation of a given concept.")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="ID of the concept", required=true, dataType="string", paramType="path"), @ApiImplicitParam(name="keyspace", value="Name of graph to use", dataType="string", paramType="query")})
    private String conceptByIdOntology(Request req, Response res) {
        String keyspace = Utilities.getKeyspace(req);
        try (GraknGraph graph = GraphFactory.getInstance().getGraph(keyspace);){
            Concept concept = graph.getConcept(ConceptId.of((String)req.params(":id")));
            String string = HALConceptRepresentationBuilder.renderHALConceptOntology((Concept)concept, (String)keyspace);
            return string;
        }
        catch (Exception e) {
            throw new GraknEngineServerException(500, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="/ontology")
    @ApiOperation(value="Produces a JSONObject containing meta-ontology types instances.", notes="The built JSONObject will contain ontology nodes divided in roles, entities, relations and resources.", response=JSONObject.class)
    @ApiImplicitParam(name="keyspace", value="Name of graph to use", dataType="string", paramType="query")
    private String ontology(Request req, Response res) {
        String keyspace = Utilities.getKeyspace(req);
        try (GraknGraph graph = GraphFactory.getInstance().getGraph(keyspace);){
            JSONObject responseObj = new JSONObject();
            responseObj.put("roles", (Object)this.instances((Type)graph.admin().getMetaRoleType()));
            responseObj.put("entities", (Object)this.instances((Type)graph.admin().getMetaEntityType()));
            responseObj.put("relations", (Object)this.instances((Type)graph.admin().getMetaRelationType()));
            responseObj.put("resources", (Object)this.instances((Type)graph.admin().getMetaResourceType()));
            String string = responseObj.toString();
            return string;
        }
        catch (Exception e) {
            throw new GraknEngineServerException(500, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="/match")
    @ApiOperation(value="Executes match query on the server and build a representation for each concept in the query result. Return type is determined by the content type. Either application/graql or application/json/hal")
    @ApiImplicitParams(value={@ApiImplicitParam(name="keyspace", value="Name of graph to use", dataType="string", paramType="query"), @ApiImplicitParam(name="query", value="Match query to execute", required=true, dataType="string", paramType="query"), @ApiImplicitParam(name="reasoner", value="Boolean used to decide whether run reasoner together with the current query.", required=true, dataType="sting/boolean", paramType="query")})
    private String match(Request req, Response res) {
        String keyspace = Utilities.getKeyspace(req);
        boolean useReasoner = Boolean.parseBoolean(req.queryParams("reasoner"));
        boolean materialise = Boolean.parseBoolean(req.queryParams("materialise"));
        try (GraknGraph graph = GraphFactory.getInstance().getGraph(keyspace);){
            QueryBuilder qb = graph.graql().infer(useReasoner).materialise(materialise);
            Query parsedQuery = qb.parse(req.queryParams("query"));
            if (parsedQuery instanceof MatchQuery || parsedQuery instanceof AggregateQuery || parsedQuery instanceof ComputeQuery) {
                switch (Utilities.getAcceptType(req)) {
                    case "application/hal+json": {
                        String string = this.formatAsHAL((MatchQuery)parsedQuery, keyspace);
                        return string;
                    }
                    case "application/graql": {
                        String string = this.formatAsGraql(parsedQuery);
                        return string;
                    }
                }
                String string = this.formatAsHAL((MatchQuery)parsedQuery, keyspace);
                return string;
            }
            throw new GraknEngineServerException(500, "Only \"read-only\" queries are allowed from Grakn web-dashboard.");
        }
        catch (Exception e) {
            throw new GraknEngineServerException(500, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="/analytics")
    @ApiOperation(value="Executes compute query on the server and build HAL representation of result or returns string containing statistics.")
    @ApiImplicitParams(value={@ApiImplicitParam(name="keyspace", value="Name of graph to use", dataType="string", paramType="query"), @ApiImplicitParam(name="query", value="Compute query to execute", required=true, dataType="string", paramType="query")})
    private String compute(Request req, Response res) {
        try (GraknGraph graph = GraphFactory.getInstance().getGraph(Utilities.getKeyspace(req));){
            ComputeQuery computeQuery = (ComputeQuery)graph.graql().parse(req.queryParams("query"));
            JSONObject response = new JSONObject();
            if (computeQuery instanceof PathQuery) {
                PathQuery pathQuery = (PathQuery)computeQuery;
                Optional result = pathQuery.execute();
                if (result.isPresent()) {
                    response.put(COMPUTE_RESPONSE_TYPE, (Object)"HAL");
                    JSONArray array = new JSONArray();
                    ((List)result.get()).forEach(concept -> array.put((Object)HALConceptRepresentationBuilder.renderHALConceptData((Concept)concept, (int)0, (String)Utilities.getKeyspace(req))));
                    response.put(COMPUTE_RESPONSE_FIELD, (Object)array);
                } else {
                    response.put(COMPUTE_RESPONSE_TYPE, (Object)"string");
                    response.put(COMPUTE_RESPONSE_FIELD, (Object)"No path found");
                }
            } else {
                response.put(COMPUTE_RESPONSE_TYPE, (Object)"string");
                response.put(COMPUTE_RESPONSE_FIELD, (Object)this.formatAsGraql((Query<?>)computeQuery));
            }
            String string = response.toString();
            return string;
        }
        catch (Exception e) {
            throw new GraknEngineServerException(500, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="/preMaterialiseAll")
    @ApiOperation(value="Pre materialise all the rules on the graph.")
    @ApiImplicitParam(name="keyspace", value="Name of graph to use", dataType="string", paramType="query")
    private String preMaterialiseAll(Request req, Response res) {
        try (GraknGraph graph = GraphFactory.getInstance().getGraph(Utilities.getKeyspace(req));){
            Reasoner.precomputeInferences((GraknGraph)graph);
            String string = "Done.";
            return string;
        }
        catch (Exception e) {
            throw new GraknEngineServerException(500, e);
        }
    }

    private String formatAsHAL(MatchQuery query, String keyspace) {
        Collection results = query.admin().streamWithVarNames().collect(Collectors.toList());
        Json resultobj = HALConceptRepresentationBuilder.renderHALArrayData((MatchQuery)query, (Collection)results, (String)keyspace);
        return resultobj.toString();
    }

    private String formatAsGraql(Query<?> query) {
        return query.resultsString(Printers.graql((ResourceType[])new ResourceType[0])).map(x -> x.replaceAll("\u001b\\[\\d+[m]", "")).collect(Collectors.joining("\n"));
    }

    private JSONArray instances(Type type) {
        return new JSONArray((Object)type.subTypes().stream().map(Type::getName).toArray());
    }
}

