/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.loader;

import ai.grakn.engine.backgroundtasks.TaskStatus;
import ai.grakn.engine.backgroundtasks.distributed.DistributedTaskManager;
import ai.grakn.engine.loader.LoaderTask;
import ai.grakn.engine.util.ConfigProperties;
import ai.grakn.graql.InsertQuery;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Semaphore;
import java.util.stream.Collectors;
import javafx.util.Pair;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Loader {
    private static final Logger LOG = LoggerFactory.getLogger(Loader.class);
    private static final ConfigProperties properties = ConfigProperties.getInstance();
    private final DistributedTaskManager manager;
    private Semaphore blocker = new Semaphore(25);
    private int batchSize;
    private final Collection<InsertQuery> queries;
    private final String keyspace;

    public Loader(String keyspace) {
        this.keyspace = keyspace;
        this.queries = new HashSet<InsertQuery>();
        this.manager = DistributedTaskManager.getInstance().open();
        this.setBatchSize(properties.getPropertyAsInt("blockingLoader.batch-size"));
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public Loader setBatchSize(int size) {
        this.batchSize = size;
        return this;
    }

    public Loader setQueueSize(int size) {
        this.blocker = new Semaphore(size);
        return this;
    }

    public void flush() {
        if (this.queries.size() > 0) {
            this.sendQueriesToLoader(this.queries);
            this.queries.clear();
        }
    }

    public void add(InsertQuery query) {
        this.queries.add(query);
        if (this.queries.size() >= this.batchSize) {
            this.sendQueriesToLoader(new HashSet<InsertQuery>(this.queries));
            this.queries.clear();
        }
    }

    public void sendQueriesToLoader(Collection<InsertQuery> batch) {
        try {
            this.blocker.acquire();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        String taskId = this.manager.scheduleTask(new LoaderTask(), this.keyspace, new Date(), 0L, this.getConfiguration(batch));
        CompletableFuture completableFuture = this.manager.completableFuture(taskId);
        completableFuture.thenAccept(i -> this.releaseSemaphore());
        completableFuture.exceptionally(i -> {
            this.releaseSemaphore();
            return null;
        });
    }

    private void releaseSemaphore() {
        this.blocker.release();
    }

    private Boolean allTasksFinished(Collection<String> tasks) {
        this.printLoaderState();
        if (tasks.stream().allMatch(this::isCompleted)) {
            return true;
        }
        try {
            Thread.sleep(500L);
        }
        catch (Exception e) {
            LOG.error("Problem sleeping.");
        }
        return false;
    }

    public void waitToFinish() {
        this.waitToFinish(60000);
    }

    public void waitToFinish(int timeout) {
        this.flush();
        long initial = new Date().getTime();
        Collection<String> currentTasks = this.getTasks();
        while (new Date().getTime() - initial < (long)timeout) {
            if (this.allTasksFinished(currentTasks).booleanValue()) {
                this.printLoaderState();
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (Exception e) {
                LOG.error("Problem sleeping.");
            }
        }
    }

    public void printLoaderState() {
        LOG.info(new JSONObject().put(TaskStatus.CREATED.name(), this.getTasks(TaskStatus.CREATED).size()).put(TaskStatus.SCHEDULED.name(), this.getTasks(TaskStatus.SCHEDULED).size()).put(TaskStatus.RUNNING.name(), this.getTasks(TaskStatus.RUNNING).size()).put(TaskStatus.COMPLETED.name(), this.getTasks(TaskStatus.COMPLETED).size()).put(TaskStatus.FAILED.name(), this.getTasks(TaskStatus.FAILED).size()).toString());
    }

    private Collection<String> getTasks() {
        return this.manager.storage().getTasks(null, LoaderTask.class.getName(), this.keyspace, 100000, 0).stream().map(Pair::getKey).collect(Collectors.toSet());
    }

    private Collection<String> getTasks(TaskStatus status) {
        return this.manager.storage().getTasks(status, LoaderTask.class.getName(), this.keyspace, 100000, 0).stream().map(Pair::getKey).collect(Collectors.toSet());
    }

    private boolean isCompleted(String taskID) {
        TaskStatus status = this.manager.getState(taskID);
        return status == TaskStatus.COMPLETED || status == TaskStatus.FAILED;
    }

    private JSONObject getConfiguration(Collection<InsertQuery> queries) {
        JSONObject json = new JSONObject();
        json.put("keyspace", (Object)this.keyspace);
        json.put("inserts", (Collection)queries.stream().map(Object::toString).collect(Collectors.toList()));
        return json;
    }
}

