/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.loader;

import ai.grakn.Grakn;
import ai.grakn.GraknGraph;
import ai.grakn.engine.backgroundtasks.BackgroundTask;
import ai.grakn.engine.loader.Loader;
import ai.grakn.engine.util.ConfigProperties;
import ai.grakn.exception.GraknValidationException;
import ai.grakn.graql.Graql;
import ai.grakn.graql.InsertQuery;
import ai.grakn.graql.QueryBuilder;
import ai.grakn.util.ErrorMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoaderTask
implements BackgroundTask {
    private static final Logger LOG = LoggerFactory.getLogger(Loader.class);
    private static final int repeatCommits = ConfigProperties.getInstance().getPropertyAsInt("loader.repeat-commits");
    private final QueryBuilder builder = Graql.withoutGraph().infer(false);

    @Override
    public void start(Consumer<String> saveCheckpoint, JSONObject configuration) {
        this.attemptInsertions(this.getURI(configuration), this.getKeyspace(configuration), this.getInserts(configuration));
    }

    @Override
    public void stop() {
        throw new UnsupportedOperationException("Loader task cannot be stopped");
    }

    @Override
    public void pause() {
        throw new UnsupportedOperationException("Loader task cannot be paused");
    }

    @Override
    public void resume(Consumer<String> saveCheckpoint, String lastCheckpoint) {
        throw new UnsupportedOperationException("Loader task cannot be resumed");
    }

    private void attemptInsertions(String uri, String keyspace, Collection<InsertQuery> inserts) {
        try (GraknGraph graph = Grakn.factory((String)uri, (String)keyspace).getGraphBatchLoading();){
            int i = 0;
        }
    }

    private boolean insertQueriesInOneTransaction(GraknGraph graph, Collection<InsertQuery> inserts) {
        try {
            graph.showImplicitConcepts(true);
            inserts.forEach(q -> {
                List cfr_ignored_0 = (List)q.withGraph(graph).execute();
            });
            graph.commit();
        }
        catch (GraknValidationException e) {
            this.throwException(ErrorMessage.FAILED_VALIDATION.getMessage(new Object[]{e.getMessage()}), inserts);
        }
        catch (IllegalArgumentException e) {
            this.throwException(ErrorMessage.ILLEGAL_ARGUMENT_EXCEPTION.getMessage(new Object[]{e.getMessage()}), inserts);
        }
        catch (Throwable throwable) {
            this.handleError(throwable, 1);
            return false;
        }
        return true;
    }

    private void throwException(String message) {
        this.throwException(message, Collections.emptyList());
    }

    private void throwException(String message, Collection<InsertQuery> inserts) {
        throw new RuntimeException(message + inserts);
    }

    private void handleError(Throwable e, int i) {
        LOG.error("Caught exception ", e);
        try {
            Thread.sleep((i + 2) * 1000);
        }
        catch (InterruptedException e1) {
            LOG.error("Caught exception ", (Throwable)e1);
        }
    }

    private Collection<InsertQuery> getInserts(JSONObject configuration) {
        if (configuration.has("inserts")) {
            ArrayList inserts = new ArrayList();
            configuration.getJSONArray("inserts").forEach(i -> inserts.add((String)i));
            return inserts.stream().map(arg_0 -> ((QueryBuilder)this.builder).parse(arg_0)).collect(Collectors.toList());
        }
        throw new IllegalArgumentException(ErrorMessage.ILLEGAL_ARGUMENT_EXCEPTION.getMessage(new Object[]{"No inserts", configuration}));
    }

    private String getKeyspace(JSONObject configuration) {
        if (configuration.has("keyspace")) {
            return configuration.getString("keyspace");
        }
        throw new IllegalArgumentException(ErrorMessage.ILLEGAL_ARGUMENT_EXCEPTION.getMessage(new Object[]{"No keyspace", configuration}));
    }

    private String getURI(JSONObject configuration) {
        if (configuration.has("uri")) {
            return configuration.getString("uri");
        }
        return "localhost:4567";
    }
}

