/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.postprocessing;

import ai.grakn.engine.postprocessing.Cache;
import ai.grakn.factory.GraphFactory;
import ai.grakn.graph.internal.AbstractGraknGraph;
import ai.grakn.util.ErrorMessage;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConceptFixer {
    private static final Logger LOG = LoggerFactory.getLogger((String)"post-processing");
    private static final int MAX_RETRY = 10;

    ConceptFixer() {
    }

    public static void checkCasting(Cache cache, String keyspace, String castingId) {
        boolean notDone = true;
        int retry = 0;
        while (notDone) {
            try {
                AbstractGraknGraph graph = (AbstractGraknGraph)GraphFactory.getInstance().getGraph(keyspace);
                Throwable throwable = null;
                try {
                    if (graph.fixDuplicateCasting((Object)castingId)) {
                        graph.commit(false);
                    }
                    cache.deleteJobCasting(graph.getKeyspace(), castingId);
                    notDone = false;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (graph == null) continue;
                    if (throwable != null) {
                        try {
                            graph.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    graph.close();
                }
            }
            catch (Exception e) {
                LOG.warn(ErrorMessage.POSTPROCESSING_ERROR.getMessage(new Object[]{"casting", e.getMessage()}), (Throwable)e);
                if (retry++ > 10) {
                    LOG.error(ErrorMessage.UNABLE_TO_ANALYSE_CONCEPT.getMessage(new Object[]{castingId, e.getMessage()}), (Throwable)e);
                    notDone = false;
                    continue;
                }
                ConceptFixer.performRetry(retry);
            }
        }
    }

    public static void checkResources(Cache cache, String keyspace, Set<String> resourceIds) {
        boolean notDone = true;
        int retry = 0;
        while (notDone) {
            try {
                AbstractGraknGraph graph = (AbstractGraknGraph)GraphFactory.getInstance().getGraph(keyspace);
                Throwable throwable = null;
                try {
                    if (graph.fixDuplicateResources(resourceIds)) {
                        graph.commit(false);
                    }
                    resourceIds.forEach(resourceId -> cache.deleteJobResource(graph.getKeyspace(), (String)resourceId));
                    notDone = false;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (graph == null) continue;
                    if (throwable != null) {
                        try {
                            graph.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    graph.close();
                }
            }
            catch (Exception e) {
                LOG.warn(ErrorMessage.POSTPROCESSING_ERROR.getMessage(new Object[]{"resource", e.getMessage()}), (Throwable)e);
                if (retry++ > 10) {
                    String message = "";
                    for (String resourceId2 : resourceIds) {
                        message = message + resourceId2;
                    }
                    LOG.error(ErrorMessage.UNABLE_TO_ANALYSE_CONCEPT.getMessage(new Object[]{message, e.getMessage()}), (Throwable)e);
                    notDone = false;
                    continue;
                }
                ConceptFixer.performRetry(retry);
            }
        }
    }

    private static int performRetry(int retry) {
        double seed = 1.0 + Math.random() * 5.0;
        double waitTime = (double)(++retry) * 2.0 + seed;
        LOG.debug(ErrorMessage.BACK_OFF_RETRY.getMessage(new Object[]{waitTime}));
        try {
            Thread.sleep((long)Math.ceil(waitTime * 1000.0));
        }
        catch (InterruptedException e1) {
            LOG.error("Exception", (Throwable)e1);
        }
        return retry;
    }
}

