/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.postprocessing;

import ai.grakn.engine.postprocessing.Cache;
import ai.grakn.engine.postprocessing.ConceptFixer;
import ai.grakn.engine.util.ConfigProperties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostProcessing {
    private static final Logger LOG = LoggerFactory.getLogger((String)"post-processing");
    private static final String CASTING_STAGE = "Scanning for duplicate castings . . .";
    private static final String RESOURCE_STAGE = "Scanning for duplicate resources . . .";
    private static PostProcessing instance = null;
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private ExecutorService postpool = Executors.newFixedThreadPool(1);
    private ExecutorService statDump = Executors.newSingleThreadExecutor();
    private Set<Future> futures;
    private String currentStage;
    private final Cache cache = Cache.getInstance();

    private PostProcessing() {
        this.futures = ConcurrentHashMap.newKeySet();
        this.isRunning.set(false);
    }

    public static synchronized PostProcessing getInstance() {
        if (instance == null) {
            instance = new PostProcessing();
        }
        return instance;
    }

    public void run() {
        if (!this.isRunning.get()) {
            LOG.info("Starting maintenance.");
            this.isRunning.set(true);
            this.statDump.submit(this::dumpStats);
            this.performTasks();
            this.futures = ConcurrentHashMap.newKeySet();
            this.isRunning.set(false);
            LOG.info("Maintenance completed.");
        }
    }

    public void stop() {
        if (this.isRunning.get()) {
            LOG.warn("Shutting down running tasks");
            System.out.println("Shutting down running tasks");
            this.futures.forEach(f -> f.cancel(true));
            this.postpool.shutdownNow();
            this.statDump.shutdownNow();
        }
        this.isRunning.set(false);
    }

    public void reset() {
        this.isRunning.set(false);
        this.futures.clear();
        this.postpool = Executors.newFixedThreadPool(ConfigProperties.getInstance().getAvailableThreads());
        this.statDump = Executors.newSingleThreadExecutor();
    }

    private void performTasks() {
        this.currentStage = CASTING_STAGE;
        LOG.info(this.currentStage);
        this.performCastingFix();
        this.waitToContinue();
        this.currentStage = RESOURCE_STAGE;
        LOG.info(this.currentStage);
        this.performResourceFix();
        this.waitToContinue();
    }

    private void performCastingFix() {
        this.cache.getKeyspaces().parallelStream().forEach(keyspace -> {
            try {
                for (String castingId : this.cache.getCastingJobs((String)keyspace)) {
                    this.futures.add(this.postpool.submit(() -> ConceptFixer.checkCasting(this.cache, keyspace, castingId)));
                }
            }
            catch (RuntimeException e) {
                LOG.error("Error while trying to perform post processing on graph [" + keyspace + "]", (Throwable)e);
            }
        });
    }

    private void performResourceFix() {
        this.cache.getKeyspaces().parallelStream().forEach(keyspace -> {
            try {
                this.futures.add(this.postpool.submit(() -> {
                    Set<String> deepCopy = this.cache.getResourceJobs((String)keyspace).stream().map(String::new).collect(Collectors.toSet());
                    ConceptFixer.checkResources(this.cache, keyspace, deepCopy);
                }));
            }
            catch (RuntimeException e) {
                LOG.error("Error while trying to perform post processing on graph [" + keyspace + "]", (Throwable)e);
            }
        });
    }

    private void waitToContinue() {
        for (Future future : this.futures) {
            try {
                future.get(4L, TimeUnit.HOURS);
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error("Error while waiting for future: ", (Throwable)e);
            }
            catch (TimeoutException e) {
                LOG.warn("Timeout exception waiting for future to complete", (Throwable)e);
            }
        }
        this.futures.clear();
    }

    private void dumpStats() {
        while (this.isRunning.get()) {
            LOG.info("--------------------Current Status of Post Processing--------------------");
            this.dumpStatsType("Casting");
            this.dumpStatsType("Resources");
            LOG.info("Save in Progress: " + this.cache.isSaveInProgress());
            LOG.info("Current Stage: " + this.currentStage);
            LOG.info("-------------------------------------------------------------------------");
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException e) {
                LOG.error("Exception", (Throwable)e);
            }
        }
    }

    private void dumpStatsType(String typeName) {
        long total = 0L;
        LOG.info(typeName + " Jobs:");
        for (String keyspace : this.cache.getKeyspaces()) {
            long numJobs = 0L;
            if (typeName.equals("Casting")) {
                numJobs = this.cache.getCastingJobs(keyspace).size();
            } else if (typeName.equals("Resources")) {
                numJobs = this.cache.getResourceJobs(keyspace).size();
            }
            LOG.info("        Post processing step [" + typeName + " for Graph [" + keyspace + "] has jobs : " + numJobs);
            total += numJobs;
        }
        LOG.info("    Total " + typeName + " Jobs: " + total);
    }
}

