/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.postprocessing;

import ai.grakn.engine.backgroundtasks.BackgroundTask;
import ai.grakn.engine.postprocessing.Cache;
import ai.grakn.engine.postprocessing.PostProcessing;
import ai.grakn.engine.util.ConfigProperties;
import java.util.function.Consumer;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostProcessingTask
implements BackgroundTask {
    private static final Logger LOG = LoggerFactory.getLogger((String)"post-processing");
    private static final ConfigProperties properties = ConfigProperties.getInstance();
    private static final PostProcessing postProcessing = PostProcessing.getInstance();
    private static final Cache cache = Cache.getInstance();
    private static final long timeLapse = properties.getPropertyAsLong("backgroundTasks.post-processing-delay");

    @Override
    public void start(Consumer<String> saveCheckpoint, JSONObject configuration) {
        long lastJob = cache.getLastTimeJobAdded();
        long currentTime = System.currentTimeMillis();
        LOG.info("Checking post processing should run: " + (currentTime - lastJob >= timeLapse));
        if (currentTime - lastJob >= timeLapse) {
            postProcessing.run();
        }
    }

    @Override
    public void stop() {
        postProcessing.stop();
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume(Consumer<String> saveCheckpoint, String lastCheckpoint) {
    }
}

