/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.user;

import ai.grakn.GraknGraph;
import ai.grakn.concept.ResourceType;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Random;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class Password {
    private static final Random RANDOM = new SecureRandom();
    private static final int ITERATIONS = 10000;
    private static final int KEY_LENGTH = 256;

    private Password() {
        throw new UnsupportedOperationException();
    }

    public static byte[] getNextSalt(GraknGraph graph) {
        byte[] salt;
        String saltString;
        ResourceType saltResourceType = graph.getResourceType("user-password-salt");
        do {
            salt = new byte[16];
            saltString = Password.getString(salt);
            RANDOM.nextBytes(salt);
        } while (saltResourceType.getResource((Object)saltString) != null);
        return salt;
    }

    public static byte[] hash(char[] password, byte[] salt) {
        PBEKeySpec spec = new PBEKeySpec(password, salt, 10000, 256);
        Arrays.fill(password, '\u0000');
        try {
            SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            byte[] byArray = skf.generateSecret(spec).getEncoded();
            return byArray;
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new AssertionError("Error while hashing a password: " + e.getMessage(), e);
        }
        finally {
            spec.clearPassword();
        }
    }

    public static boolean isExpectedPassword(char[] password, byte[] salt, byte[] expectedHash) {
        byte[] pwdHash = Password.hash(password, salt);
        Arrays.fill(password, '\u0000');
        if (pwdHash.length != expectedHash.length) {
            return false;
        }
        for (int i = 0; i < pwdHash.length; ++i) {
            if (pwdHash[i] == expectedHash[i]) continue;
            return false;
        }
        return true;
    }

    public static String getString(byte[] bytes) {
        return new String(Base64.getEncoder().encode(bytes));
    }

    public static byte[] getBytes(String string) {
        return Base64.getDecoder().decode(string.getBytes());
    }
}

