/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.user;

import ai.grakn.engine.user.SystemKeyspaceUsers;
import java.util.HashMap;
import java.util.Map;
import mjson.Json;

public class UsersHandler {
    public static final String USER_ENTITY = "user";
    public static final String USER_NAME = "user-name";
    public static final String USER_PASSWORD = "user-password";
    public static final String USER_SALT = "user-password-salt";
    public static final String USER_FIRST_NAME = "user-first-name";
    public static final String USER_LAST_NAME = "user-last-name";
    public static final String USER_EMAIL = "user-email";
    public static final String USER_IS_ADMIN = "user-is-admin";
    private static UsersHandler instance = null;
    private final Map<String, Json> usersMap = new HashMap<String, Json>();

    public static synchronized UsersHandler getInstance() {
        if (instance == null) {
            instance = new SystemKeyspaceUsers();
        }
        return instance;
    }

    protected UsersHandler() {
    }

    public boolean addUser(Json user) {
        if (this.usersMap.containsKey(user.at(USER_NAME))) {
            return false;
        }
        this.usersMap.put(user.at(USER_NAME).asString(), user);
        return true;
    }

    public boolean updateUser(Json user) {
        if (this.usersMap.containsKey(user.at(USER_NAME))) {
            return false;
        }
        this.usersMap.put(user.at(USER_NAME).asString(), user);
        return true;
    }

    public boolean userExists(String username) {
        return this.usersMap.containsKey(username);
    }

    public boolean validateUser(String username, String hashedPassword) {
        if (this.userExists(username)) {
            return this.getUser(username).is(USER_PASSWORD, (Object)hashedPassword);
        }
        return false;
    }

    public Json getUser(String username) {
        return this.usersMap.get(username);
    }

    public boolean removeUser(String username) {
        return this.usersMap.remove(username) != null;
    }

    public Json allUsers(int offset, int limit) {
        return Json.make(this.usersMap.values());
    }
}

