/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine;

import ai.grakn.engine.backgroundtasks.TaskManager;
import ai.grakn.engine.backgroundtasks.distributed.DistributedTaskManager;
import ai.grakn.engine.backgroundtasks.standalone.StandaloneTaskManager;
import ai.grakn.engine.controller.AuthController;
import ai.grakn.engine.controller.CommitLogController;
import ai.grakn.engine.controller.GraphFactoryController;
import ai.grakn.engine.controller.StatusController;
import ai.grakn.engine.controller.TasksController;
import ai.grakn.engine.controller.UserController;
import ai.grakn.engine.controller.VisualiserController;
import ai.grakn.engine.postprocessing.PostProcessing;
import ai.grakn.engine.postprocessing.PostProcessingTask;
import ai.grakn.engine.session.RemoteSession;
import ai.grakn.engine.util.ConfigProperties;
import ai.grakn.engine.util.JWTHandler;
import ai.grakn.exception.GraknEngineServerException;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import mjson.Json;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Filter;
import spark.Request;
import spark.Spark;

public class GraknEngineServer {
    private static final ConfigProperties prop = ConfigProperties.getInstance();
    private static final Logger LOG = LoggerFactory.getLogger(GraknEngineServer.class);
    private static final int WEBSOCKET_TIMEOUT = 3600000;
    private static final Set<String> unauthenticatedEndPoints = new HashSet<String>(Arrays.asList("/auth/session/", "/shell/remote", "/graph_factory", "/auth/enabled/"));
    public static final boolean isPasswordProtected = prop.getPropertyAsBool("password.protected");
    private static TaskManager taskManager;

    public static void main(String[] args) {
        boolean distributed = prop.getPropertyAsBool("taskmanager.distributed");
        GraknEngineServer.start(distributed);
    }

    public static void start(boolean taskManagerIsDistributed) {
        GraknEngineServer.startTaskManager(taskManagerIsDistributed);
        GraknEngineServer.startHTTP();
        GraknEngineServer.startPostprocessing();
        GraknEngineServer.printStartMessage(prop.getProperty("server.host"), prop.getProperty("server.port"), prop.getLogFilePath());
    }

    public static void stop() throws Exception {
        GraknEngineServer.stopTaskManager();
    }

    private static void startTaskManager(boolean taskManagerIsDistributed) {
        taskManager = taskManagerIsDistributed ? new DistributedTaskManager() : new StandaloneTaskManager();
    }

    public static void startHTTP() {
        Spark.ipAddress((String)prop.getProperty("server.host"));
        Spark.port((int)prop.getPropertyAsInt("server.port"));
        Spark.staticFiles.externalLocation(prop.getPath("server.static-file-dir"));
        Spark.webSocket((String)"/shell/remote", RemoteSession.class);
        Spark.webSocketIdleTimeoutMillis((int)3600000);
        new VisualiserController();
        new GraphFactoryController();
        new CommitLogController();
        new StatusController();
        new AuthController();
        new UserController();
        new TasksController(taskManager);
        Spark.before((Filter[])new Filter[]{(req, res) -> GraknEngineServer.checkAuthorization(req)});
        Spark.exception(GraknEngineServerException.class, (e, request, response) -> {
            response.status(((GraknEngineServerException)e).getStatus());
            response.body("New exception: " + e.getMessage() + " - Please refer to grakn.log file for full stack trace.");
        });
        Spark.awaitInitialization();
    }

    private static void startPostprocessing() {
        taskManager.createTask(PostProcessingTask.class.getName(), GraknEngineServer.class.getName(), Instant.now(), prop.getPropertyAsInt("backgroundTasks.time-lapse"), Json.object());
    }

    public static void stopHTTP() {
        Spark.stop();
        boolean running = true;
        while (running) {
            try {
                Spark.port();
            }
            catch (IllegalStateException e) {
                LOG.debug("Spark server has been stopped");
                running = false;
            }
        }
    }

    private static void stopTaskManager() throws Exception {
        PostProcessing.getInstance().stop();
        taskManager.close();
    }

    public static TaskManager getTaskManager() {
        return taskManager;
    }

    private static void checkAuthorization(Request request) {
        if (!isPasswordProtected) {
            return;
        }
        if (!unauthenticatedEndPoints.contains(request.pathInfo())) {
            boolean authenticated;
            try {
                if (request.headers("Authorization") == null || !request.headers("Authorization").startsWith("Bearer ")) {
                    throw new GraknEngineServerException(400, "Authorization field in header corrupted or absent.");
                }
                String token = request.headers("Authorization").substring(7);
                authenticated = JWTHandler.verifyJWT(token);
            }
            catch (Exception e) {
                throw new GraknEngineServerException(400, e);
            }
            if (!authenticated) {
                Spark.halt((int)401, (String)"User not authenticated.");
            }
        }
    }

    private static void printStartMessage(String host, String port, String logFilePath) {
        String address = "http://" + host + ":" + port;
        LOG.info("\nGrakn LOG file located at [" + logFilePath + "]");
        LOG.info("\n==================================================");
        LOG.info("\n" + String.format("     ___  ___  ___  _  __ _  _     ___  ___     %n    / __|| _ \\/   \\| |/ /| \\| |   /   \\|_ _|    %n   | (_ ||   /| - || ' < | .` | _ | - | | |     %n    \\___||_|_\\|_|_||_|\\_\\|_|\\_|(_)|_|_||___|   %n%n Web Dashboard available at [%s]", address));
        LOG.info("\n==================================================");
    }
}

