/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.backgroundtasks;

import ai.grakn.engine.TaskStatus;
import java.io.Serializable;
import java.time.Instant;
import java.util.Base64;
import java.util.UUID;
import mjson.Json;
import org.apache.commons.lang.SerializationUtils;

public class TaskState
implements Serializable {
    private final String taskId;
    private TaskStatus status;
    private Instant statusChangeTime;
    private String statusChangedBy;
    private final String taskClassName;
    private String creator;
    private String engineID;
    private Instant runAt;
    private Boolean recurring;
    private long interval;
    private String stackTrace;
    private String exception;
    private String taskCheckpoint;
    private Json configuration;

    public TaskState(String taskClassName) {
        this.status = TaskStatus.CREATED;
        this.statusChangeTime = Instant.now();
        this.taskClassName = taskClassName;
        this.taskId = UUID.randomUUID().toString();
    }

    public TaskState(String taskClassName, String id, TaskStatus status) {
        this.taskId = id;
        this.taskClassName = taskClassName;
        this.status = status;
    }

    public String getId() {
        return this.taskId;
    }

    public TaskState status(TaskStatus status) {
        this.status = status;
        this.statusChangeTime = Instant.now();
        return this;
    }

    public TaskStatus status() {
        return this.status;
    }

    public TaskState statusChangeTime(Instant statusChangeTime) {
        this.statusChangeTime = statusChangeTime;
        return this;
    }

    public Instant statusChangeTime() {
        return this.statusChangeTime;
    }

    public TaskState statusChangedBy(String statusChangedBy) {
        this.statusChangedBy = statusChangedBy;
        return this;
    }

    public String statusChangedBy() {
        return this.statusChangedBy;
    }

    public String taskClassName() {
        return this.taskClassName;
    }

    public TaskState creator(String creator) {
        this.creator = creator;
        return this;
    }

    public String creator() {
        return this.creator;
    }

    public TaskState engineID(String engineID) {
        this.engineID = engineID;
        return this;
    }

    public String engineID() {
        return this.engineID;
    }

    public TaskState runAt(Instant runAt) {
        this.runAt = runAt;
        return this;
    }

    public Instant runAt() {
        return this.runAt;
    }

    public TaskState isRecurring(Boolean recurring) {
        this.recurring = recurring;
        return this;
    }

    public Boolean isRecurring() {
        return this.recurring != null && this.recurring != false;
    }

    public TaskState interval(long interval) {
        this.interval = interval;
        return this;
    }

    public long interval() {
        return this.interval;
    }

    public TaskState stackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
        return this;
    }

    public String stackTrace() {
        return this.stackTrace;
    }

    public TaskState exception(String exceptionMessage) {
        this.exception = exceptionMessage;
        return this;
    }

    public String exception() {
        return this.exception;
    }

    public TaskState checkpoint(String taskCheckpoint) {
        this.taskCheckpoint = taskCheckpoint;
        return this;
    }

    public String checkpoint() {
        return this.taskCheckpoint;
    }

    public TaskState configuration(Json configuration) {
        this.configuration = configuration;
        return this;
    }

    public Json configuration() {
        return this.configuration;
    }

    public static String serialize(TaskState task) {
        return Base64.getMimeEncoder().encodeToString(SerializationUtils.serialize((Serializable)task));
    }

    public static TaskState deserialize(String task) {
        return (TaskState)SerializationUtils.deserialize((byte[])Base64.getMimeDecoder().decode(task));
    }
}

