/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.backgroundtasks.distributed;

import ai.grakn.engine.backgroundtasks.config.ConfigHelper;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.imps.CuratorFrameworkState;

public class ZookeeperConnection {
    private final CuratorFramework zookeeperConnection = ConfigHelper.client();

    public ZookeeperConnection() {
        try {
            this.zookeeperConnection.start();
            if (!this.zookeeperConnection.blockUntilConnected(30, TimeUnit.SECONDS)) {
                throw new RuntimeException("Could not connect to zookeeper");
            }
            this.createZKPaths();
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not connect to zookeeper");
        }
    }

    public void close() {
        this.zookeeperConnection.close();
        boolean notStopped = true;
        while (notStopped) {
            if (this.zookeeperConnection.getState() != CuratorFrameworkState.STOPPED) continue;
            notStopped = false;
        }
    }

    public CuratorFramework connection() {
        return this.zookeeperConnection;
    }

    private void createZKPaths() throws Exception {
        if (this.zookeeperConnection.checkExists().forPath("/scheduler") == null) {
            this.zookeeperConnection.create().creatingParentContainersIfNeeded().forPath("/scheduler");
        }
        if (this.zookeeperConnection.checkExists().forPath("/task_runners/watch") == null) {
            this.zookeeperConnection.create().creatingParentContainersIfNeeded().forPath("/task_runners/watch");
        }
        if (this.zookeeperConnection.checkExists().forPath("/task_runners/last_state") == null) {
            this.zookeeperConnection.create().creatingParentContainersIfNeeded().forPath("/task_runners/last_state");
        }
        if (this.zookeeperConnection.checkExists().forPath("/tasks") == null) {
            this.zookeeperConnection.create().creatingParentContainersIfNeeded().forPath("/tasks");
        }
    }
}

