/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.backgroundtasks.taskstatestorage;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.concept.Instance;
import ai.grakn.concept.Resource;
import ai.grakn.concept.ResourceType;
import ai.grakn.concept.RoleType;
import ai.grakn.concept.TypeName;
import ai.grakn.engine.TaskStatus;
import ai.grakn.engine.backgroundtasks.TaskState;
import ai.grakn.engine.backgroundtasks.TaskStateStorage;
import ai.grakn.engine.postprocessing.EngineCache;
import ai.grakn.engine.util.SystemOntologyElements;
import ai.grakn.exception.EngineStorageException;
import ai.grakn.exception.GraknBackendException;
import ai.grakn.factory.EngineGraknGraphFactory;
import ai.grakn.graql.Graql;
import ai.grakn.graql.MatchQuery;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.Var;
import ai.grakn.util.Schema;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskStateGraphStore
implements TaskStateStorage {
    private static final String TASK_VAR = "task";
    private static final int retries = 10;
    private final Logger LOG = LoggerFactory.getLogger(TaskStateGraphStore.class);

    @Override
    public String newState(TaskState task) throws EngineStorageException {
        Optional<Boolean> result;
        Var state = Graql.var((String)TASK_VAR).isa(Graql.name((TypeName)SystemOntologyElements.SCHEDULED_TASK)).has(SystemOntologyElements.TASK_ID.getValue(), (Object)task.getId()).has(SystemOntologyElements.STATUS, Graql.var().value((Object)TaskStatus.CREATED.toString())).has(SystemOntologyElements.TASK_CLASS_NAME, Graql.var().value((Object)task.taskClassName())).has(SystemOntologyElements.CREATED_BY, Graql.var().value((Object)task.creator())).has(SystemOntologyElements.RUN_AT, Graql.var().value((Object)task.runAt().toEpochMilli())).has(SystemOntologyElements.RECURRING, Graql.var().value((Object)task.isRecurring())).has(SystemOntologyElements.RECUR_INTERVAL, Graql.var().value((Object)task.interval())).has(SystemOntologyElements.SERIALISED_TASK, Graql.var().value((Object)TaskState.serialize(task)));
        if (task.configuration() != null) {
            state.has(SystemOntologyElements.TASK_CONFIGURATION, Graql.var().value((Object)task.configuration().toString()));
        }
        if (!(result = this.attemptCommitToSystemGraph(graph -> {
            graph.graql().insert(new Var[]{state}).execute();
            return true;
        }, true)).isPresent()) {
            throw new EngineStorageException("Concept " + task.getId() + " could not be saved in storage");
        }
        return task.getId();
    }

    @Override
    public Boolean updateState(TaskState task) {
        HashSet<TypeName> resourcesToDettach = new HashSet<TypeName>();
        Var resources = Graql.var((String)TASK_VAR);
        resourcesToDettach.add(SystemOntologyElements.SERIALISED_TASK);
        resources.has(SystemOntologyElements.SERIALISED_TASK, Graql.var().value((Object)TaskState.serialize(task)));
        if (task.status() != null) {
            resourcesToDettach.add(SystemOntologyElements.STATUS);
            resourcesToDettach.add(SystemOntologyElements.STATUS_CHANGE_TIME);
            resources.has(SystemOntologyElements.STATUS, Graql.var().value((Object)task.status().toString())).has(SystemOntologyElements.STATUS_CHANGE_TIME, Graql.var().value((Object)new Date().getTime()));
        }
        if (task.statusChangedBy() != null) {
            resourcesToDettach.add(SystemOntologyElements.STATUS_CHANGE_BY);
            resources.has(SystemOntologyElements.STATUS_CHANGE_BY, Graql.var().value((Object)task.statusChangedBy()));
        }
        if (task.engineID() != null) {
            resourcesToDettach.add(SystemOntologyElements.ENGINE_ID);
            resources.has(SystemOntologyElements.ENGINE_ID, Graql.var().value((Object)task.engineID()));
        }
        if (task.exception() != null) {
            resourcesToDettach.add(SystemOntologyElements.TASK_EXCEPTION);
            resourcesToDettach.add(SystemOntologyElements.STACK_TRACE);
            resources.has(SystemOntologyElements.TASK_EXCEPTION, Graql.var().value((Object)task.exception()));
            if (task.stackTrace() != null) {
                resources.has(SystemOntologyElements.STACK_TRACE, Graql.var().value((Object)task.stackTrace()));
            }
        }
        if (task.checkpoint() != null) {
            resourcesToDettach.add(SystemOntologyElements.TASK_CHECKPOINT);
            resources.has(SystemOntologyElements.TASK_CHECKPOINT, Graql.var().value((Object)task.checkpoint()));
        }
        if (task.configuration() != null) {
            resourcesToDettach.add(SystemOntologyElements.TASK_CONFIGURATION);
            resources.has(SystemOntologyElements.TASK_CONFIGURATION, Graql.var().value((Object)task.configuration().toString()));
        }
        Optional<Boolean> result = this.attemptCommitToSystemGraph(graph -> {
            Instance taskConcept = ((Resource)graph.getResourcesByValue((Object)task.getId()).iterator().next()).owner();
            resourcesToDettach.forEach(typeName -> {
                RoleType roleType = (RoleType)graph.getType(Schema.Resource.HAS_RESOURCE_OWNER.getName(typeName));
                taskConcept.relations(new RoleType[]{roleType}).forEach(Concept::delete);
            });
            resources.id(taskConcept.getId());
            graph.graql().insert(new Var[]{resources}).execute();
            return true;
        }, true);
        return result.isPresent();
    }

    @Override
    public TaskState getState(String id) throws EngineStorageException {
        Optional<TaskState> result = this.attemptCommitToSystemGraph(graph -> {
            Instance instance = ((Resource)graph.getResourcesByValue((Object)id).iterator().next()).owner();
            return this.instanceToState((GraknGraph)graph, instance);
        }, false);
        if (!result.isPresent()) {
            throw new EngineStorageException("Concept " + id + " not found in storage");
        }
        return result.get();
    }

    public TaskState instanceToState(GraknGraph graph, Instance instance) {
        ResourceType serialisedResourceType = graph.getResourceType(SystemOntologyElements.SERIALISED_TASK.getValue());
        String serialisedTask = (String)((Resource)instance.resources(new ResourceType[]{serialisedResourceType}).iterator().next()).getValue();
        return TaskState.deserialize(serialisedTask);
    }

    @Override
    public Set<TaskState> getTasks(TaskStatus taskStatus, String taskClassName, String createdBy, int limit, int offset) {
        return this.getTasks(taskStatus, taskClassName, createdBy, limit, offset, false);
    }

    public Set<TaskState> getTasks(TaskStatus taskStatus, String taskClassName, String createdBy, int limit, int offset, Boolean recurring) {
        Optional<Set> result;
        Var matchVar = Graql.var((String)TASK_VAR).isa(Graql.name((TypeName)SystemOntologyElements.SCHEDULED_TASK));
        if (taskStatus != null) {
            matchVar.has(SystemOntologyElements.STATUS, Graql.var().value((Object)taskStatus.toString()));
        }
        if (taskClassName != null) {
            matchVar.has(SystemOntologyElements.TASK_CLASS_NAME, Graql.var().value((Object)taskClassName));
        }
        if (createdBy != null) {
            matchVar.has(SystemOntologyElements.CREATED_BY, Graql.var().value((Object)createdBy));
        }
        if (recurring != null) {
            matchVar.has(SystemOntologyElements.RECURRING, Graql.var().value((Object)recurring));
        }
        return (result = this.attemptCommitToSystemGraph(graph -> {
            MatchQuery q = graph.graql().match(new Pattern[]{matchVar});
            if (limit > 0) {
                q.limit((long)limit);
            }
            if (offset > 0) {
                q.offset((long)offset);
            }
            return ((List)q.execute()).stream().map(map -> map.values().stream().findFirst()).map(Optional::get).map(c -> this.instanceToState((GraknGraph)graph, c.asInstance())).collect(Collectors.toSet());
        }, false)).isPresent() ? result.get() : new HashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private <T> Optional<T> attemptCommitToSystemGraph(Function<GraknGraph, T> function, boolean commit) {
        double sleepFor = 100.0;
        for (int i = 0; i < 10; ++i) {
            Optional<T> optional;
            Throwable throwable;
            GraknGraph graph;
            long time;
            block25: {
                block26: {
                    this.LOG.debug("Attempting " + (commit ? "commit" : "query") + " on system graph @ t" + Thread.currentThread().getId());
                    time = System.currentTimeMillis();
                    graph = EngineGraknGraphFactory.getInstance().getGraph("graknSystem");
                    throwable = null;
                    T result = function.apply(graph);
                    if (commit) {
                        EngineCache engineCache = EngineCache.getInstance();
                        graph.admin().commit(engineCache.getResourceJobs(graph.getKeyspace()), engineCache.getCastingJobs(graph.getKeyspace()));
                    }
                    optional = Optional.of(result);
                    if (graph == null) break block25;
                    if (throwable == null) break block26;
                    try {
                        graph.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block25;
                }
                graph.close();
            }
            this.LOG.debug("Took " + (System.currentTimeMillis() - time) + " to " + (commit ? "commit" : "query") + " to system graph @ t" + Thread.currentThread().getId());
            return optional;
            {
                catch (Throwable throwable3) {
                    try {
                        try {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (graph != null) {
                                if (throwable != null) {
                                    try {
                                        graph.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    graph.close();
                                }
                            }
                            throw throwable4;
                        }
                    }
                    catch (GraknBackendException e) {
                        this.LOG.debug("Trouble inserting " + ExceptionUtils.getFullStackTrace((Throwable)e));
                        this.LOG.debug("Took " + (System.currentTimeMillis() - time) + " to " + (commit ? "commit" : "query") + " to system graph @ t" + Thread.currentThread().getId());
                    }
                    catch (Throwable e) {
                        try {
                            this.LOG.error("Failed to validate the graph when updating the state " + ExceptionUtils.getFullStackTrace((Throwable)e));
                            this.LOG.debug("Took " + (System.currentTimeMillis() - time) + " to " + (commit ? "commit" : "query") + " to system graph @ t" + Thread.currentThread().getId());
                        }
                        catch (Throwable throwable6) {
                            this.LOG.debug("Took " + (System.currentTimeMillis() - time) + " to " + (commit ? "commit" : "query") + " to system graph @ t" + Thread.currentThread().getId());
                            throw throwable6;
                        }
                        break;
                    }
                }
            }
            try {
                Thread.sleep((long)sleepFor);
                continue;
            }
            catch (InterruptedException e) {
                this.LOG.error(ExceptionUtils.getFullStackTrace((Throwable)e));
                continue;
            }
            finally {
                sleepFor = 0.5 * (Math.pow(2.0, i) - 1.0);
            }
        }
        return Optional.empty();
    }
}

