/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.backgroundtasks.taskstatestorage;

import ai.grakn.engine.TaskStatus;
import ai.grakn.engine.backgroundtasks.TaskState;
import ai.grakn.engine.backgroundtasks.TaskStateStorage;
import ai.grakn.exception.EngineStorageException;
import java.lang.ref.SoftReference;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TaskStateInMemoryStore
implements TaskStateStorage {
    private final Map<String, SoftReference<TaskState>> storage = new ConcurrentHashMap<String, SoftReference<TaskState>>();

    @Override
    public String newState(TaskState state) {
        this.storage.put(state.getId(), new SoftReference<TaskState>(state));
        return state.getId();
    }

    @Override
    public Boolean updateState(TaskState state) {
        this.storage.put(state.getId(), new SoftReference<TaskState>(state));
        return true;
    }

    @Override
    public TaskState getState(String id) {
        if (id == null || !this.storage.containsKey(id)) {
            throw new EngineStorageException("Could not retrieve id " + id);
        }
        return this.storage.get(id).get();
    }

    @Override
    public Set<TaskState> getTasks(TaskStatus taskStatus, String taskClassName, String createdBy, int limit, int offset) {
        HashSet<TaskState> res = new HashSet<TaskState>();
        int count = 0;
        for (Map.Entry<String, SoftReference<TaskState>> x : this.storage.entrySet()) {
            TaskState state = x.getValue().get();
            if (state == null || taskStatus != null && state.status() != taskStatus || taskClassName != null && !Objects.equals(state.taskClassName(), taskClassName) || createdBy != null && !Objects.equals(state.creator(), createdBy)) continue;
            if (count < offset) {
                ++count;
                continue;
            }
            if (limit > 0 && count >= limit + offset) break;
            ++count;
            res.add(state);
        }
        return res;
    }
}

