/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.controller;

import ai.grakn.concept.ConceptId;
import ai.grakn.engine.postprocessing.EngineCache;
import ai.grakn.engine.util.ConfigProperties;
import ai.grakn.exception.GraknEngineServerException;
import ai.grakn.util.ErrorMessage;
import ai.grakn.util.Schema;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Request;
import spark.Response;
import spark.Spark;

public class CommitLogController {
    private final EngineCache cache = EngineCache.getInstance();
    private final Logger LOG = LoggerFactory.getLogger(CommitLogController.class);

    public CommitLogController() {
        Spark.post((String)"/commit_log", this::submitConcepts);
        Spark.delete((String)"/commit_log", this::deleteConcepts);
    }

    @GET
    @Path(value="/commit_log")
    @ApiOperation(value="Delete all the post processing jobs for a specific keyspace")
    @ApiImplicitParam(name="keysoace", value="The key space of an opened graph", required=true, dataType="string", paramType="path")
    private String deleteConcepts(Request req, Response res) {
        String graphName = req.queryParams("keyspace");
        if (graphName == null) {
            res.status(400);
            return ErrorMessage.NO_PARAMETER_PROVIDED.getMessage(new Object[]{"keyspace", "delete"});
        }
        this.cache.getCastingJobs(graphName).clear();
        this.cache.getResourceJobs(graphName).clear();
        return "The cache of Graph [" + graphName + "] has been cleared";
    }

    @GET
    @Path(value="/commit_log")
    @ApiOperation(value="Submits post processing jobs for a specific keyspace")
    @ApiImplicitParams(value={@ApiImplicitParam(name="keyspace", value="The key space of an opened graph", required=true, dataType="string", paramType="path"), @ApiImplicitParam(name="concepts", value="A Json Array of IDs representing concepts to be post processed", required=true, dataType="string", paramType="body")})
    private String submitConcepts(Request req, Response res) {
        try {
            String graphName = req.queryParams("keyspace");
            if (graphName == null) {
                graphName = ConfigProperties.getInstance().getProperty("graphdatabase.default-keyspace");
            }
            this.LOG.info("Commit log received for graph [" + graphName + "]");
            JSONArray jsonArray = (JSONArray)new JSONObject(req.body()).get("concepts");
            block6: for (Object object : jsonArray) {
                JSONObject jsonObject = (JSONObject)object;
                String conceptVertexId = jsonObject.getString("concept-vertex-id");
                String conceptIndex = jsonObject.getString("concept-index");
                Schema.BaseType type = Schema.BaseType.valueOf((String)jsonObject.getString("concept-base-type"));
                switch (type) {
                    case CASTING: {
                        this.cache.addJobCasting(graphName, conceptIndex, ConceptId.of((Object)conceptVertexId));
                        continue block6;
                    }
                    case RESOURCE: {
                        this.cache.addJobResource(graphName, conceptIndex, ConceptId.of((Object)conceptVertexId));
                        continue block6;
                    }
                }
                this.LOG.warn(ErrorMessage.CONCEPT_POSTPROCESSING.getMessage(new Object[]{conceptVertexId, type.name()}));
            }
            return "Graph [" + graphName + "] now has [" + this.cache.getNumJobs(graphName) + "] post processing jobs";
        }
        catch (Exception e) {
            throw new GraknEngineServerException(500, e);
        }
    }
}

