/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.controller;

import ai.grakn.engine.util.ConfigProperties;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Enumeration;
import java.util.Properties;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import mjson.Json;
import spark.Request;
import spark.Response;
import spark.Spark;

@Path(value="/status")
@Api(value="/status", description="Endpoints used to retrieve all the info about the current instance of Grakn")
@Produces(value={"application/json"})
public class StatusController {
    public StatusController() {
        Spark.get((String)"/status/config", this::getStatus);
    }

    @GET
    @Path(value="/config")
    @ApiOperation(value="Return config file as a JSONObject.")
    private String getStatus(Request req, Response res) {
        Json configObj = Json.object();
        Properties props = ConfigProperties.getInstance().getProperties();
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            configObj.set(key, (Object)props.getProperty(key));
        }
        configObj.delAt("JWT.secret");
        return configObj.toString();
    }
}

