/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.controller;

import ai.grakn.engine.TaskStatus;
import ai.grakn.engine.backgroundtasks.TaskManager;
import ai.grakn.engine.backgroundtasks.TaskState;
import ai.grakn.exception.EngineStorageException;
import ai.grakn.exception.GraknEngineServerException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.time.Instant;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import mjson.Json;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Request;
import spark.Response;
import spark.Spark;

@Path(value="/tasks")
@Api(value="/tasks", description="Endpoints used to query and control queued background tasks.", produces="application/json")
public class TasksController {
    private final Logger LOG = LoggerFactory.getLogger(TasksController.class);
    private final TaskManager manager;

    public TasksController(TaskManager manager) {
        if (manager == null) {
            throw new GraknEngineServerException(500, "Task manager has not been instantiated.");
        }
        this.manager = manager;
        Spark.get((String)"/tasks/all", this::getTasks);
        Spark.get((String)"/tasks/:id", this::getTask);
        Spark.put((String)"/tasks/:id/stop", this::stopTask);
        Spark.post((String)"/tasks/schedule", this::scheduleTask);
    }

    @GET
    @Path(value="/all")
    @ApiOperation(value="Get tasks matching a specific TaskStatus.")
    @ApiImplicitParams(value={@ApiImplicitParam(name="status", value="TaskStatus as string.", dataType="string", paramType="query"), @ApiImplicitParam(name="className", value="Class name of BackgroundTask Object.", dataType="string", paramType="query"), @ApiImplicitParam(name="creator", value="Who instantiated these tasks.", dataType="string", paramType="query"), @ApiImplicitParam(name="limit", value="Limit the number of entries in the returned result.", dataType="integer", paramType="query"), @ApiImplicitParam(name="offset", value="Use in conjunction with limit for pagination.", dataType="integer", paramType="query")})
    private JSONArray getTasks(Request request, Response response) {
        TaskStatus status = null;
        String className = request.queryParams("className");
        String creator = request.queryParams("creator");
        int limit = 0;
        int offset = 0;
        if (request.queryParams("limit") != null) {
            limit = Integer.parseInt(request.queryParams("limit"));
        }
        if (request.queryParams("offset") != null) {
            offset = Integer.parseInt(request.queryParams("offset"));
        }
        if (request.queryParams("status") != null) {
            status = TaskStatus.valueOf((String)request.queryParams("status"));
        }
        JSONArray result = new JSONArray();
        for (TaskState state : this.manager.storage().getTasks(status, className, creator, limit, offset)) {
            result.put((Object)this.serialiseStateSubset(state));
        }
        response.type("application/json");
        return result;
    }

    @GET
    @Path(value="/:uuid")
    @ApiOperation(value="Get the state of a specific task by its ID.", produces="application/json")
    @ApiImplicitParam(name="uuid", value="ID of task.", required=true, dataType="string", paramType="path")
    private String getTask(Request request, Response response) {
        String id = request.params(":id");
        try {
            response.status(200);
            response.type("application/json");
            return this.serialiseStateFull(this.manager.storage().getState(id)).toString();
        }
        catch (EngineStorageException e) {
            throw new GraknEngineServerException(404, String.format("Could not find [%s] in task storage", id));
        }
        catch (Exception e) {
            throw new GraknEngineServerException(500, e);
        }
    }

    @PUT
    @Path(value="/:uuid/stop")
    @ApiOperation(value="Stop a running or paused task.")
    @ApiImplicitParam(name="uuid", value="ID of task.", required=true, dataType="string", paramType="path")
    private String stopTask(Request request, Response response) {
        try {
            String id = request.params(":id");
            this.manager.stopTask(id, this.getClass().getName());
            return "";
        }
        catch (Exception e) {
            throw new GraknEngineServerException(500, e);
        }
    }

    @POST
    @Path(value="/schedule")
    @ApiOperation(value="Schedule a task.")
    @ApiImplicitParams(value={@ApiImplicitParam(name="className", value="Class name of object implementing the BackgroundTask interface", required=true, dataType="string", paramType="query"), @ApiImplicitParam(name="createdBy", value="String representing the user scheduling this task", required=true, dataType="string", paramType="query"), @ApiImplicitParam(name="runAt", value="Time to run at as milliseconds since the UNIX epoch", required=true, dataType="long", paramType="query"), @ApiImplicitParam(name="interval", value="If set the task will be marked as recurring and the value will be the time in milliseconds between repeated executions of this task. Value should be as Long.", dataType="long", paramType="query"), @ApiImplicitParam(name="configuration", value="JSON Object that will be given to the task as configuration.", dataType="String", paramType="body")})
    private String scheduleTask(Request request, Response response) {
        String className = request.queryParams("className");
        String createdBy = request.queryParams("creator");
        String runAt = request.queryParams("runAt");
        Long interval = 0L;
        Json configuration = Json.object();
        if (request.queryParams("interval") != null) {
            interval = Long.valueOf(request.queryParams("interval"));
        }
        if (className == null || createdBy == null || runAt == null) {
            throw new GraknEngineServerException(400, "Missing mandatory parameters");
        }
        try {
            if (request.body() != null && !request.body().isEmpty()) {
                configuration = Json.read((String)request.body());
            }
            String id = this.manager.createTask(className, createdBy, Instant.ofEpochMilli(Long.parseLong(runAt)), interval, configuration);
            response.type("application/json");
            return Json.object((Object[])new Object[]{"id", id}).toString();
        }
        catch (Exception e) {
            this.LOG.error(ExceptionUtils.getFullStackTrace((Throwable)e));
            throw new GraknEngineServerException(500, e);
        }
    }

    private JSONObject serialiseStateSubset(TaskState state) {
        return new JSONObject().put("id", (Object)state.getId()).put("status", (Object)state.status()).put("creator", (Object)state.creator()).put("className", (Object)state.taskClassName()).put("runAt", (Object)state.runAt()).put("recurring", (Object)state.isRecurring());
    }

    private JSONObject serialiseStateFull(TaskState state) {
        return this.serialiseStateSubset(state).put("interval", state.interval()).put("exception", (Object)state.exception()).put("stackTrace", (Object)state.stackTrace()).put("engineID", (Object)state.engineID()).put("configuration", (Object)state.configuration());
    }
}

