/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.loader;

import ai.grakn.GraknGraph;
import ai.grakn.engine.backgroundtasks.BackgroundTask;
import ai.grakn.engine.postprocessing.EngineCache;
import ai.grakn.engine.util.ConfigProperties;
import ai.grakn.exception.GraknValidationException;
import ai.grakn.factory.EngineGraknGraphFactory;
import ai.grakn.graql.Graql;
import ai.grakn.graql.InsertQuery;
import ai.grakn.graql.QueryBuilder;
import ai.grakn.util.ErrorMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import mjson.Json;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoaderTask
implements BackgroundTask {
    private static final Logger LOG = LoggerFactory.getLogger(LoaderTask.class);
    private static final int repeatCommits = ConfigProperties.getInstance().getPropertyAsInt("loader.repeat-commits");
    private final QueryBuilder builder = Graql.withoutGraph().infer(false);

    @Override
    public void start(Consumer<String> saveCheckpoint, Json configuration) {
        this.attemptInsertions(this.getKeyspace(configuration), this.getInserts(configuration));
    }

    @Override
    public void stop() {
        throw new UnsupportedOperationException("Loader task cannot be stopped");
    }

    @Override
    public void pause() {
        throw new UnsupportedOperationException("Loader task cannot be paused");
    }

    @Override
    public void resume(Consumer<String> saveCheckpoint, String lastCheckpoint) {
        throw new UnsupportedOperationException("Loader task cannot be resumed");
    }

    private void attemptInsertions(String keyspace, Collection<InsertQuery> inserts) {
        try (GraknGraph graph = EngineGraknGraphFactory.getInstance().getGraphBatchLoading(keyspace);){
            int i = 0;
        }
    }

    private boolean insertQueriesInOneTransaction(GraknGraph graph, Collection<InsertQuery> inserts) {
        try {
            graph.showImplicitConcepts(true);
            inserts.forEach(q -> {
                List cfr_ignored_0 = (List)q.withGraph(graph).execute();
            });
            EngineCache engineCache = EngineCache.getInstance();
            graph.admin().commit(engineCache.getResourceJobs(graph.getKeyspace()), engineCache.getCastingJobs(graph.getKeyspace()));
        }
        catch (GraknValidationException e) {
            this.throwException(ErrorMessage.FAILED_VALIDATION.getMessage(new Object[]{e.getMessage()}), inserts);
        }
        catch (IllegalArgumentException e) {
            this.throwException(ErrorMessage.ILLEGAL_ARGUMENT_EXCEPTION.getMessage(new Object[]{e.getMessage()}), inserts);
        }
        catch (Throwable throwable) {
            this.handleError(throwable, 1);
            return false;
        }
        return true;
    }

    private void throwException(String message) {
        this.throwException(message, Collections.emptyList());
    }

    private void throwException(String message, Collection<InsertQuery> inserts) {
        throw new RuntimeException(message + inserts);
    }

    private void handleError(Throwable e, int i) {
        LOG.error("Caught exception ", e);
        try {
            Thread.sleep((i + 2) * 1000);
        }
        catch (InterruptedException e1) {
            LOG.error("Caught exception ", (Throwable)e1);
        }
    }

    private Collection<InsertQuery> getInserts(Json configuration) {
        if (configuration.has("inserts")) {
            ArrayList inserts = new ArrayList();
            configuration.at("inserts").asJsonList().forEach(i -> inserts.add(i.asString()));
            return inserts.stream().map(arg_0 -> ((QueryBuilder)this.builder).parse(arg_0)).collect(Collectors.toList());
        }
        throw new IllegalArgumentException(ErrorMessage.ILLEGAL_ARGUMENT_EXCEPTION.getMessage(new Object[]{"No inserts", configuration}));
    }

    private String getKeyspace(Json configuration) {
        if (configuration.has("keyspace")) {
            return configuration.at("keyspace").asString();
        }
        throw new IllegalArgumentException(ErrorMessage.ILLEGAL_ARGUMENT_EXCEPTION.getMessage(new Object[]{"No keyspace", configuration}));
    }
}

