/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.postprocessing;

import ai.grakn.GraknGraph;
import ai.grakn.concept.ConceptId;
import ai.grakn.engine.postprocessing.EngineCache;
import ai.grakn.factory.EngineGraknGraphFactory;
import ai.grakn.util.ErrorMessage;
import ai.grakn.util.Schema;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConceptFixer {
    private static final Logger LOG = LoggerFactory.getLogger((String)"post-processing");
    private static final int MAX_RETRY = 10;

    ConceptFixer() {
    }

    static void checkResources(String keyspace, String index, Set<ConceptId> conceptIds) {
        ConceptFixer.runPostProcessingJob(graph -> ConceptFixer.runResourceFix(graph, index, conceptIds), keyspace, index, conceptIds);
    }

    static void checkCastings(String keyspace, String index, Set<ConceptId> conceptIds) {
        ConceptFixer.runPostProcessingJob(graph -> ConceptFixer.runCastingFix(graph, index, conceptIds), keyspace, index, conceptIds);
    }

    private static void runPostProcessingJob(Function<GraknGraph, Consumer<EngineCache>> postProcessor, String keyspace, String conceptIndex, Set<ConceptId> conceptIds) {
        String jobId = UUID.randomUUID().toString();
        boolean notDone = true;
        int retry = 0;
        while (notDone) {
            try (GraknGraph graph = EngineGraknGraphFactory.getInstance().getGraph(keyspace);){
                Consumer<EngineCache> jobFinaliser = postProcessor.apply(graph);
                ConceptFixer.validateMerged(graph, conceptIndex, conceptIds).ifPresent(message -> {
                    throw new RuntimeException((String)message);
                });
                graph.admin().commitNoLogs();
                jobFinaliser.accept(EngineCache.getInstance());
                return;
            }
            catch (Throwable t) {
                t.printStackTrace();
                LOG.warn(ErrorMessage.POSTPROCESSING_ERROR.getMessage(new Object[]{jobId, t.getMessage()}), t);
                if (retry > 10) {
                    notDone = false;
                }
                retry = ConceptFixer.performRetry(retry);
            }
        }
        StringBuilder failingConcepts = new StringBuilder();
        for (ConceptId id : conceptIds) {
            failingConcepts.append(id.getValue()).append(",");
        }
        LOG.error(ErrorMessage.UNABLE_TO_ANALYSE_CONCEPT.getMessage(new Object[]{failingConcepts.toString(), jobId}));
    }

    private static Optional<String> validateMerged(GraknGraph graph, String conceptIndex, Set<ConceptId> conceptIds) {
        int numConceptFound = 0;
        for (ConceptId conceptId : conceptIds) {
            if (graph.getConcept(conceptId) == null || ++numConceptFound <= 1) continue;
            StringBuilder conceptIdValues = new StringBuilder();
            for (ConceptId id : conceptIds) {
                conceptIdValues.append(id.getValue()).append(",");
            }
            return Optional.of("Not all concept were merged. The set of concepts [" + conceptIds.size() + "] with IDs [" + conceptIdValues.toString() + "] matched more than one concept");
        }
        if (graph.admin().getConcept(Schema.ConceptProperty.INDEX, conceptIndex) == null) {
            return Optional.of("The concept index [" + conceptIndex + "] did not return any concept");
        }
        return Optional.empty();
    }

    private static Consumer<EngineCache> runResourceFix(GraknGraph graph, String index, Set<ConceptId> conceptIds) {
        graph.admin().fixDuplicateResources(index, conceptIds);
        return cache -> {
            conceptIds.forEach(conceptId -> cache.deleteJobResource(graph.getKeyspace(), index, (ConceptId)conceptId));
            cache.clearJobSetResources(graph.getKeyspace(), index);
        };
    }

    private static Consumer<EngineCache> runCastingFix(GraknGraph graph, String index, Set<ConceptId> conceptIds) {
        graph.admin().fixDuplicateCastings(index, conceptIds);
        return cache -> {
            conceptIds.forEach(conceptId -> cache.deleteJobCasting(graph.getKeyspace(), index, (ConceptId)conceptId));
            cache.clearJobSetCastings(graph.getKeyspace(), index);
        };
    }

    private static int performRetry(int retry) {
        double seed = 1.0 + Math.random() * 5.0;
        double waitTime = (double)(++retry) * 2.0 + seed;
        LOG.debug(ErrorMessage.BACK_OFF_RETRY.getMessage(new Object[]{waitTime}));
        try {
            Thread.sleep((long)Math.ceil(waitTime * 1000.0));
        }
        catch (InterruptedException e1) {
            LOG.error("Exception", (Throwable)e1);
        }
        return retry;
    }
}

