/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.postprocessing;

import ai.grakn.concept.ConceptId;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class EngineCache {
    private final Map<String, Map<String, Set<ConceptId>>> castings = new ConcurrentHashMap<String, Map<String, Set<ConceptId>>>();
    private final Map<String, Map<String, Set<ConceptId>>> resources = new ConcurrentHashMap<String, Map<String, Set<ConceptId>>>();
    private final AtomicBoolean saveInProgress = new AtomicBoolean(false);
    private static EngineCache instance = null;
    private final AtomicLong lastTimeModified = new AtomicLong(System.currentTimeMillis());

    public static synchronized EngineCache getInstance() {
        if (instance == null) {
            instance = new EngineCache();
        }
        return instance;
    }

    private EngineCache() {
    }

    boolean isSaveInProgress() {
        return this.saveInProgress.get();
    }

    public Set<String> getKeyspaces() {
        HashSet<String> keyspaces = new HashSet<String>();
        keyspaces.addAll(this.castings.keySet());
        keyspaces.addAll(this.resources.keySet());
        return keyspaces;
    }

    public long getNumJobs(String keyspace) {
        return this.getNumCastingJobs(keyspace) + this.getNumCastingJobs(keyspace);
    }

    public long getNumCastingJobs(String keyspace) {
        return this.getNumJobsCount(this.getCastingJobs(keyspace));
    }

    public long getNumResourceJobs(String keyspace) {
        return this.getNumJobsCount(this.getResourceJobs(keyspace));
    }

    private long getNumJobsCount(Map<String, Set<ConceptId>> cache) {
        return cache.values().stream().mapToLong(Set::size).sum();
    }

    public Map<String, Set<ConceptId>> getCastingJobs(String keyspace) {
        return this.castings.computeIfAbsent(keyspace, key -> new ConcurrentHashMap());
    }

    public void addJobCasting(String keyspace, String castingIndex, ConceptId castingId) {
        this.addJob(this.castings, keyspace, castingIndex, castingId);
    }

    public void deleteJobCasting(String keyspace, String castingIndex, ConceptId castingId) {
        this.deleteJob(this.castings, keyspace, castingIndex, castingId);
    }

    public Map<String, Set<ConceptId>> getResourceJobs(String keyspace) {
        return this.resources.computeIfAbsent(keyspace, key -> new ConcurrentHashMap());
    }

    public void addJobResource(String keyspace, String resourceIndex, ConceptId resourceId) {
        this.addJob(this.resources, keyspace, resourceIndex, resourceId);
    }

    public void deleteJobResource(String keyspace, String resourceIndex, ConceptId resourceId) {
        this.deleteJob(this.resources, keyspace, resourceIndex, resourceId);
    }

    private void addJob(Map<String, Map<String, Set<ConceptId>>> cache, String keyspace, String index, ConceptId vertexId) {
        this.updateLastTimeJobAdded();
        Map keyspaceSpecificCache = cache.computeIfAbsent(keyspace, key -> new ConcurrentHashMap());
        Set indexSpecificSet = keyspaceSpecificCache.computeIfAbsent(index, i -> ConcurrentHashMap.newKeySet());
        indexSpecificSet.add(vertexId);
    }

    private void deleteJob(Map<String, Map<String, Set<ConceptId>>> cache, String keyspace, String index, ConceptId vertexId) {
        this.updateLastTimeJobAdded();
        Map<String, Set<ConceptId>> keyspaceSpecificCache = cache.get(keyspace);
        if (keyspaceSpecificCache != null) {
            Set<ConceptId> indexSpecificSet = keyspaceSpecificCache.get(index);
            indexSpecificSet.remove(vertexId);
        }
    }

    public void clearJobSetResources(String keyspace, String conceptIndex) {
        this.clearJobSet(conceptIndex, this.resources.get(keyspace));
    }

    public void clearJobSetCastings(String keyspace, String conceptIndex) {
        this.clearJobSet(conceptIndex, this.castings.get(keyspace));
    }

    private void clearJobSet(String conceptIndex, Map<String, Set<ConceptId>> cache) {
        if (cache.containsKey(conceptIndex) && cache.get(conceptIndex).isEmpty()) {
            cache.remove(conceptIndex);
        }
    }

    long getLastTimeJobAdded() {
        return this.lastTimeModified.get();
    }

    private void updateLastTimeJobAdded() {
        this.lastTimeModified.set(System.currentTimeMillis());
    }
}

