/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.session;

import ai.grakn.Grakn;
import ai.grakn.GraknGraph;
import ai.grakn.engine.GraknEngineServer;
import ai.grakn.engine.session.GraqlSession;
import ai.grakn.engine.user.UsersHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import mjson.Json;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSocket
public class RemoteSession {
    private final Map<Session, GraqlSession> sessions = new HashMap<Session, GraqlSession>();
    private final Function<String, GraknGraph> getGraph;
    private final Logger LOG = LoggerFactory.getLogger(RemoteSession.class);

    public RemoteSession() {
        this(keyspace -> Grakn.factory((String)"localhost:4567", (String)keyspace).getGraph());
    }

    public RemoteSession(Function<String, GraknGraph> getGraph) {
        this.getGraph = getGraph;
    }

    @OnWebSocketConnect
    public void onConnect(Session session) {
    }

    @OnWebSocketClose
    public void onClose(Session session, int statusCode, String reason) {
        String message = "Websocket closed, code: " + statusCode + ", reason: " + reason;
        if (statusCode == 1000 || statusCode == 1001) {
            this.LOG.debug(message);
        } else {
            this.LOG.error(message);
        }
        this.sessions.remove(session).close();
    }

    @OnWebSocketMessage
    public void onMessage(Session session, String message) {
        try {
            this.LOG.debug("Received message: " + message);
            Json json = Json.read((String)message);
            if (json.is("action", (Object)"init")) {
                this.startSession(session, json);
            } else {
                this.sessions.get(session).handleMessage(json);
            }
        }
        catch (Throwable e) {
            this.LOG.error("Exception", (Object)ExceptionUtils.getFullStackTrace((Throwable)e));
            throw e;
        }
    }

    private void startSession(Session session, Json json) {
        if (this.sessionAuthorised(json)) {
            String keyspace = json.at("keyspace").asString();
            String outputFormat = json.at("outputFormat").asString();
            boolean showImplicitTypes = json.at("implicit").asBoolean();
            boolean infer = json.at("infer").asBoolean();
            boolean materialise = json.at("materialise").asBoolean();
            GraqlSession graqlSession = new GraqlSession(session, () -> this.getGraph.apply(keyspace), outputFormat, showImplicitTypes, infer, materialise);
            this.sessions.put(session, graqlSession);
        } else {
            session.close(1008, "Unauthorised: incorrect username or password");
        }
    }

    private boolean sessionAuthorised(Json json) {
        if (!GraknEngineServer.isPasswordProtected) {
            return true;
        }
        Json username = json.at("username");
        Json password = json.at("password");
        boolean credentialsProvided = username != null && password != null;
        return credentialsProvided && UsersHandler.getInstance().validateUser(username.asString(), password.asString());
    }
}

