/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.user;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.concept.ResourceType;
import ai.grakn.concept.TypeName;
import ai.grakn.engine.postprocessing.EngineCache;
import ai.grakn.engine.user.Password;
import ai.grakn.engine.user.UsersHandler;
import ai.grakn.factory.EngineGraknGraphFactory;
import ai.grakn.graql.AskQuery;
import ai.grakn.graql.Graql;
import ai.grakn.graql.InsertQuery;
import ai.grakn.graql.MatchQuery;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.Var;
import java.util.List;
import java.util.Map;
import mjson.Json;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemKeyspaceUsers
extends UsersHandler {
    private final Logger LOG = LoggerFactory.getLogger(SystemKeyspaceUsers.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean addUser(Json userJson) {
        Var user = Graql.var().isa("user");
        try (GraknGraph graph = EngineGraknGraphFactory.getInstance().getGraph("graknSystem");){
            userJson.asJsonMap().forEach((property, value) -> {
                if (property.equals("user-password")) {
                    byte[] salt = Password.getNextSalt(graph);
                    byte[] hashedPassword = Password.hash(value.getValue().toString().toCharArray(), salt);
                    user.has("user-password", (Object)Password.getString(hashedPassword));
                    user.has("user-password-salt", (Object)Password.getString(salt));
                } else {
                    user.has(property, value.getValue());
                }
            });
            InsertQuery query = graph.graql().insert(new Var[]{user});
            query.execute();
            EngineCache engineCache = EngineCache.getInstance();
            graph.admin().commit(engineCache.getResourceJobs(graph.getKeyspace()), engineCache.getCastingJobs(graph.getKeyspace()));
            this.LOG.debug("Created user " + userJson);
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            this.LOG.error("Could not add user " + userJson + " to system graph: ", t);
            this.rethrow(t);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean userExists(String username) {
        Var lookup = Graql.var().isa("user").has("user-name", (Object)username);
        try (GraknGraph graph = EngineGraknGraphFactory.getInstance().getGraph("graknSystem");){
            AskQuery query = graph.graql().match(new Pattern[]{lookup}).ask();
            boolean bl = (Boolean)query.execute();
            return bl;
        }
        catch (Throwable t) {
            this.LOG.error("While getting all users.", t);
            this.rethrow(t);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Json getUser(String username) {
        Var lookup = Graql.var((String)"entity").isa("user").has("user-name", (Object)username);
        Var resource = Graql.var((String)"property");
        try (GraknGraph graph = EngineGraknGraphFactory.getInstance().getGraph("graknSystem");){
            MatchQuery query = graph.graql().match(new Pattern[]{lookup.has(resource)});
            List L = (List)query.execute();
            if (L.isEmpty()) {
                Json json2 = Json.nil();
                return json2;
            }
            Json user = Json.object();
            L.forEach(property -> {
                TypeName name = ((Concept)property.get("property")).asInstance().type().getName();
                Object value = ((Concept)property.get("property")).asResource().getValue();
                user.set(name.getValue(), value);
            });
            Json json = user;
            return json;
        }
        catch (Throwable t) {
            this.LOG.error("While getting all users.", t);
            this.rethrow(t);
            return Json.nil();
        }
    }

    @Override
    public boolean validateUser(String username, String passwordClient) {
        try (GraknGraph graph = EngineGraknGraphFactory.getInstance().getGraph("graknSystem");){
            List results = (List)graph.graql().match(new Pattern[]{Graql.var((String)"salt").isa("user-password-salt"), Graql.var((String)"stored-password").isa("user-password"), Graql.var((String)"entity").isa("user").has("user-name", (Object)username).has("user-password", Graql.var((String)"stored-password")).has("user-password-salt", Graql.var((String)"salt"))}).execute();
            if (!results.isEmpty()) {
                Concept saltConcept = (Concept)((Map)results.get(0)).get("salt");
                Concept passwordConcept = (Concept)((Map)results.get(0)).get("stored-password");
                if (saltConcept != null && passwordConcept != null && saltConcept.isResource() && passwordConcept.isResource()) {
                    byte[] salt = Password.getBytes(saltConcept.asResource().getValue().toString());
                    byte[] expectedPassword = Password.getBytes(passwordConcept.asResource().getValue().toString());
                    boolean bl = Password.isExpectedPassword(passwordClient.toCharArray(), salt, expectedPassword);
                    return bl;
                }
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Json allUsers(int offset, int limit) {
        Var lookup = Graql.var((String)"entity").isa("user");
        try (GraknGraph graph = EngineGraknGraphFactory.getInstance().getGraph("graknSystem");){
            MatchQuery query = graph.graql().match(new Pattern[]{lookup.has("user-name", Graql.var((String)"username"))}).limit((long)limit).offset((long)offset);
            List L = (List)query.execute();
            Json all = Json.array();
            L.forEach(concepts -> {
                String username = ((Concept)concepts.get("username")).asResource().getValue().toString();
                all.add(this.getUser(username));
            });
            Json json = all;
            return json;
        }
        catch (Throwable t) {
            this.LOG.error("While getting all users.", t);
            this.rethrow(t);
            return Json.nil();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean removeUser(String username) {
        Var lookup = Graql.var((String)"entity").isa("user").has("user-name", (Object)username);
        try (GraknGraph graph = EngineGraknGraphFactory.getInstance().getGraph("graknSystem");){
            MatchQuery query = graph.graql().match(new Pattern[]{lookup});
            List results = (List)query.execute();
            boolean exists = !results.isEmpty();
            results.forEach(map -> map.forEach((k, v) -> {
                v.asInstance().resources(new ResourceType[0]).forEach(Concept::delete);
                v.delete();
            }));
            if (exists) {
                EngineCache engineCache = EngineCache.getInstance();
                graph.admin().commit(engineCache.getResourceJobs(graph.getKeyspace()), engineCache.getCastingJobs(graph.getKeyspace()));
            }
            boolean bl = exists;
            return bl;
        }
        catch (Throwable t) {
            this.LOG.error("While getting all users.", t);
            this.rethrow(t);
            return false;
        }
    }

    @Override
    public boolean updateUser(Json user) {
        throw new UnsupportedOperationException();
    }

    private void rethrow(Throwable t) {
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new RuntimeException(t);
    }
}

