/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineID {
    private String id;
    private static EngineID instance = null;
    private final Logger LOG = LoggerFactory.getLogger(EngineID.class);

    private EngineID() {
        try {
            this.id = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            this.LOG.error("Could not get system hostname: ", (Throwable)e);
        }
        this.id = this.id + "-" + UUID.randomUUID().toString();
    }

    public static synchronized EngineID getInstance() {
        if (instance == null) {
            instance = new EngineID();
        }
        return instance;
    }

    public String id() {
        return this.id;
    }
}

