/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.util;

import ai.grakn.engine.util.ConfigProperties;
import ai.grakn.exception.GraknEngineServerException;
import com.auth0.jwt.JWTSigner;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.JWTVerifyException;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.HashMap;
import java.util.Map;

public class JWTHandler {
    private static final String issuer = "https://grakn.ai/";
    private static final String secret = ConfigProperties.getInstance().getProperty("JWT.secret");

    public static String signJWT(String username) {
        long iat = System.currentTimeMillis() / 1000L;
        long exp = iat + 3600L;
        JWTSigner signer = new JWTSigner(secret);
        HashMap<String, Object> claims = new HashMap<String, Object>();
        claims.put("iss", issuer);
        claims.put("exp", exp);
        claims.put("iat", iat);
        claims.put("username", username);
        return signer.sign(claims);
    }

    public static String extractUserFromJWT(String jwt) {
        try {
            JWTVerifier verifier = new JWTVerifier(secret);
            Map claims = verifier.verify(jwt);
            return claims.get("username").toString();
        }
        catch (Exception e) {
            throw new GraknEngineServerException(500, e);
        }
    }

    public static boolean verifyJWT(String jwt) {
        try {
            JWTVerifier verifier = new JWTVerifier(secret);
            verifier.verify(jwt);
            return true;
        }
        catch (JWTVerifyException | IOException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            return false;
        }
    }
}

