/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.factory;

import ai.grakn.GraknGraph;
import ai.grakn.engine.util.ConfigProperties;
import ai.grakn.factory.FactoryBuilder;
import ai.grakn.util.ErrorMessage;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class EngineGraknGraphFactory {
    private final Properties properties = new Properties();
    private static EngineGraknGraphFactory instance = null;

    public static synchronized EngineGraknGraphFactory getInstance() {
        if (instance == null) {
            instance = new EngineGraknGraphFactory();
        }
        return instance;
    }

    private EngineGraknGraphFactory() {
        String pathToConfig = ConfigProperties.getInstance().getPath("graphdatabase.config");
        try (FileInputStream input = new FileInputStream(pathToConfig);){
            this.properties.load(input);
        }
        catch (IOException e) {
            throw new RuntimeException(ErrorMessage.INVALID_PATH_TO_CONFIG.getMessage(new Object[]{pathToConfig}), e);
        }
    }

    public synchronized GraknGraph getGraph(String keyspace) {
        return this.getGraph(keyspace, false);
    }

    public synchronized GraknGraph getGraphBatchLoading(String keyspace) {
        return this.getGraph(keyspace, true);
    }

    public synchronized void refreshConnections() {
        FactoryBuilder.refresh();
    }

    private GraknGraph getGraph(String keyspace, boolean batchLoading) {
        return FactoryBuilder.getFactory((String)keyspace, (String)"localhost:4567", (Properties)this.properties).getGraph(batchLoading);
    }
}

