/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine;

import ai.grakn.GraknGraph;
import ai.grakn.GraknTxType;
import ai.grakn.concept.EntityType;
import ai.grakn.concept.Label;
import ai.grakn.concept.Resource;
import ai.grakn.concept.ResourceType;
import ai.grakn.concept.Thing;
import ai.grakn.engine.factory.EngineGraknGraphFactory;
import ai.grakn.exception.GraphOperationException;
import ai.grakn.exception.InvalidGraphException;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemKeyspace {
    public static final String SYSTEM_GRAPH_NAME = "graknSystem";
    private static final String SYSTEM_VERSION = "system-version";
    public static final Label KEYSPACE_ENTITY = Label.of((String)"keyspace");
    public static final Label KEYSPACE_RESOURCE = Label.of((String)"keyspace-name");
    private static final Logger LOG = LoggerFactory.getLogger(SystemKeyspace.class);
    private final ConcurrentHashMap<String, Boolean> openSpaces;
    private final EngineGraknGraphFactory factory;

    public SystemKeyspace(EngineGraknGraphFactory factory) {
        this(factory, true);
    }

    public SystemKeyspace(EngineGraknGraphFactory factory, boolean loadSystemOntology) {
        this.factory = factory;
        this.openSpaces = new ConcurrentHashMap();
        if (loadSystemOntology) {
            this.loadSystemOntology();
        }
    }

    public boolean ensureKeyspaceInitialised(String keyspace) {
        if (this.openSpaces.containsKey(keyspace)) {
            return true;
        }
        try (GraknGraph graph = this.factory.getGraph(SYSTEM_GRAPH_NAME, GraknTxType.WRITE);){
            ResourceType keyspaceName = (ResourceType)graph.getOntologyConcept(KEYSPACE_RESOURCE);
            Resource resource = keyspaceName.putResource((Object)keyspace);
            if (resource.owner() == null) {
                ((EntityType)graph.getOntologyConcept(KEYSPACE_ENTITY)).addEntity().resource(resource);
            }
            graph.admin().commitNoLogs();
        }
        catch (InvalidGraphException e) {
            throw new RuntimeException("Could not add keyspace [" + keyspace + "] to system graph", e);
        }
        return true;
    }

    public boolean containsKeyspace(String keyspace) {
        try (GraknGraph graph = this.factory.getGraph(SYSTEM_GRAPH_NAME, GraknTxType.READ);){
            boolean bl = graph.getResourceType(KEYSPACE_RESOURCE.getValue()).getResource((Object)keyspace) != null;
            return bl;
        }
    }

    public boolean deleteKeyspace(String keyspace) {
        if (keyspace.equals(SYSTEM_GRAPH_NAME)) {
            return false;
        }
        try (GraknGraph graph = this.factory.getGraph(SYSTEM_GRAPH_NAME, GraknTxType.WRITE);){
            ResourceType keyspaceName = (ResourceType)graph.getOntologyConcept(KEYSPACE_RESOURCE);
            Resource resource = keyspaceName.getResource((Object)keyspace);
            if (resource == null) {
                boolean bl = false;
                return bl;
            }
            Thing thing = resource.owner();
            if (thing != null) {
                thing.delete();
            }
            resource.delete();
            this.openSpaces.remove(keyspace);
            graph.admin().commitNoLogs();
        }
        return true;
    }

    public void loadSystemOntology() {
        try (GraknGraph graph = this.factory.getGraph(SYSTEM_GRAPH_NAME, GraknTxType.WRITE);){
            if (graph.getOntologyConcept(KEYSPACE_ENTITY) != null) {
                this.checkVersion(graph);
                return;
            }
            this.loadSystemOntology(graph);
            graph.getResourceType(SYSTEM_VERSION).putResource((Object)"0.16.0");
            graph.admin().commitNoLogs();
            LOG.info("Loaded system ontology to system keyspace.");
        }
        catch (InvalidGraphException | NullPointerException e) {
            e.printStackTrace(System.err);
            LOG.error("Could not load system ontology. The error was: " + e);
        }
    }

    private void checkVersion(GraknGraph graph) {
        Resource existingVersion = (Resource)graph.getResourceType(SYSTEM_VERSION).instances().iterator().next();
        if (!"0.16.0".equals(existingVersion.getValue())) {
            throw GraphOperationException.versionMistmatch((Resource)existingVersion);
        }
    }

    private void loadSystemOntology(GraknGraph graph) {
        ResourceType keyspaceName = graph.putResourceType("keyspace-name", ResourceType.DataType.STRING);
        graph.putEntityType("keyspace").key(keyspaceName);
        ResourceType userName = graph.putResourceType("user-name", ResourceType.DataType.STRING);
        ResourceType userPassword = graph.putResourceType("user-password", ResourceType.DataType.STRING);
        ResourceType userPasswordSalt = graph.putResourceType("user-password-salt", ResourceType.DataType.STRING);
        ResourceType userFirstName = graph.putResourceType("user-first-name", ResourceType.DataType.STRING);
        ResourceType userLastName = graph.putResourceType("user-last-name", ResourceType.DataType.STRING);
        ResourceType userEmail = graph.putResourceType("user-email", ResourceType.DataType.STRING);
        ResourceType userIsAdmin = graph.putResourceType("user-is-admin", ResourceType.DataType.BOOLEAN);
        graph.putEntityType("user").key(userName).resource(userPassword).resource(userPasswordSalt).resource(userFirstName).resource(userLastName).resource(userEmail).resource(userIsAdmin);
        graph.putResourceType(SYSTEM_VERSION, ResourceType.DataType.STRING);
    }
}

