/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.controller;

import ai.grakn.engine.postprocessing.PostProcessingTask;
import ai.grakn.engine.postprocessing.UpdatingInstanceCountTask;
import ai.grakn.engine.tasks.manager.TaskConfiguration;
import ai.grakn.engine.tasks.manager.TaskManager;
import ai.grakn.engine.tasks.manager.TaskState;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import spark.Request;
import spark.Response;
import spark.Service;

public class CommitLogController {
    private final String defaultKeyspace;
    private final TaskManager manager;
    private final int postProcessingDelay;

    public CommitLogController(Service spark, String defaultKeyspace, int postProcessingDelay, TaskManager manager) {
        this.defaultKeyspace = defaultKeyspace;
        this.postProcessingDelay = postProcessingDelay;
        this.manager = manager;
        spark.post("/commit_log", this::submitConcepts);
        spark.delete("/commit_log", this::deleteConcepts);
    }

    @DELETE
    @Path(value="/commit_log")
    @ApiOperation(value="Delete all the post processing jobs for a specific keyspace")
    @ApiImplicitParam(name="keyspace", value="The key space of an opened graph", required=true, dataType="string", paramType="path")
    private String deleteConcepts(Request req, Response res) {
        return "Delete not implemented";
    }

    @GET
    @Path(value="/commit_log")
    @ApiOperation(value="Submits post processing jobs for a specific keyspace")
    @ApiImplicitParams(value={@ApiImplicitParam(name="keyspace", value="The key space of an opened graph", required=true, dataType="string", paramType="path"), @ApiImplicitParam(name="concepts-to-fix", value="A Json Array of IDs representing concepts to be post processed", required=true, dataType="string", paramType="body"), @ApiImplicitParam(name="types-with-new-counts", value="A Json Array types with new and removed instances", required=true, dataType="string", paramType="body")})
    private String submitConcepts(Request req, Response res) {
        String keyspace = Optional.ofNullable(req.queryParams("keyspace")).orElse(this.defaultKeyspace);
        TaskState postProcessingTaskState = PostProcessingTask.createTask(this.getClass(), this.postProcessingDelay);
        TaskConfiguration postProcessingTaskConfiguration = PostProcessingTask.createConfig(keyspace, req.body());
        TaskState countingTaskState = UpdatingInstanceCountTask.createTask(this.getClass());
        TaskConfiguration countingTaskConfiguration = UpdatingInstanceCountTask.createConfig(keyspace, req.body());
        CompletableFuture.allOf(CompletableFuture.runAsync(() -> this.manager.addTask(postProcessingTaskState, postProcessingTaskConfiguration)), CompletableFuture.runAsync(() -> this.manager.addTask(countingTaskState, countingTaskConfiguration))).join();
        return "PP Task [ " + postProcessingTaskState.getId().getValue() + " ] and Counting task [" + countingTaskState.getId().getValue() + "] created for graph [" + keyspace + "]";
    }
}

